% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getDataMatrix}
\alias{getDataMatrix}
\title{Extract data matrix from Seurat object}
\usage{
getDataMatrix(
  obj,
  assay = "RNA",
  slot = "data",
  hvg = NULL,
  center = FALSE,
  scale = FALSE,
  non_negative = TRUE
)
}
\arguments{
\item{obj}{Seurat object}

\item{assay}{Get data matrix from this assay}

\item{slot}{Get data matrix from this slot (=layer)}

\item{hvg}{List of variable genes to subset the matrix. If NULL, uses
all genes}

\item{center}{Whether to center the data matrix}

\item{scale}{Whether to scale the data matrix}

\item{non_negative}{Enforce non-negative values for NMF}
}
\value{
Returns a sparse data matrix (cells per genes), subset 
according to the given parameters
}
\description{
Get the gene expression matrix from a Seurat object, optionally centered
and/or subset on highly variable genes
}
\examples{
data(sampleObj)
matrix <- getDataMatrix(sampleObj)

}
