% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{spliced_trans_length}
\alias{spliced_trans_length}
\title{Calculate Spliced Transcript Lengths}
\usage{
spliced_trans_length(input)
}
\arguments{
\item{input}{A data frame containing GENCODE annotations in GTF format, including \code{type}, \code{transcript_id}, and \code{width} columns.}
}
\value{
A data frame with two columns: \code{transcript_id} and \code{transcript_length}, where the latter is the sum of exon widths for each transcript.
}
\description{
Computes the spliced length of transcripts by summing the lengths of their constituent exons. This represents the mature RNA length after intron removal.
}
\details{
This function processes the input data to:
\enumerate{
\item Filter entries to include only exons.
\item Group exons by transcript ID.
\item Sum the widths of all exons per transcript.
}
The result provides the total length of the mature spliced RNA for each transcript.
}
\examples{

file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- load_file(file_v1)
spliced_lengths <- spliced_trans_length(gtf_v1)

}
