% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ES.R
\name{ES}
\alias{ES}
\title{Expected shortfall function}
\usage{
ES(family, p, param, size = 0, Nsim = 25000)
}
\arguments{
\item{family}{distribution name; run the function distributions() for help}

\item{p}{value (1  x 1) at which the expected shortfall needs to be computed; between 0 and 1; (e.g 0.01, 0.05)}

\item{param}{parameters of the distribution; (1 x p)}

\item{size}{additional parameter for some discrete distributions; run the command distributions() for help}

\item{Nsim}{number of simulations}
}
\value{
\item{es}{expected shortfall}
}
\description{
This function compute the expected shortfall of an univariate distribution
}
\examples{
family = "gaussian"

theta = matrix(c(-1.5, 1.7),1,2) ;
es = ES(family, (0.01), theta)
print('Expected shortfall : ')
print(es$es)


}
