% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeDSClass.R
\docType{class}
\name{GeDS-class}
\alias{GeDS-class}
\alias{GeDS-Class}
\title{GeDS Class}
\description{
A fitted GeDS object returned by the function \code{\link{NGeDS}} or
\code{\link{GGeDS}}, inheriting the methods for class \code{"GeDS"}.
Methods for functions \code{coef}, \code{knots}, \code{print}, \code{predict},
\code{plot}, and \code{lines} are available.
}
\section{Slots}{

\describe{
\item{\code{Type}}{Character string indicating the type of regression performed.
This can be \code{"LM - Univ"}/\code{"LM - Biv"} or
#' \code{"GLM - Univ"}/\code{"GLM - Biv"}, respectively corresponding to Normal
univariate/bivariate GeDS (implemented by \code{\link{NGeDS}}), and to
generalized (GNM-GLM) univariate/bivariate GeDS (implemented by
\code{\link{GGeDS}}).}

\item{\code{Linear.Knots}}{vector containing the locations of the knots of the
second order GeD spline fit produced at stage A.}

\item{\code{Quadratic.Knots}}{vector containing the locations of the knots of the
third order GeD spline fit produced in stage B.}

\item{\code{Cubic.knots}}{Vector containing the locations of the knots of the fourth
order GeD spline fit produced in stage B.}

\item{\code{Dev.Linear}}{deviance of the second order GeD spline fit, produced in
stage A.}

\item{\code{Dev.Quadratic}}{deviance of the third order GeD spline fit, produced in
stage B.}

\item{\code{Dev.Cubic}}{deviance of the fourth order GeD spline fit, produced in
stage B.}

\item{\code{RSS}}{vector containing the deviances of the second order spline
fits computed at each stage A's GeDS iteration.}

\item{\code{Linear}}{list containing the results from running \code{\link{SplineReg}}
function to fit the second order spline fit of stage A.}

\item{\code{Quadratic}}{list containing the results from running \code{\link{SplineReg}}
function used to fit the third order spline fit in stage B.}

\item{\code{Cubic}}{list containing the results from a \code{\link{SplineReg}}
function used to fit the fourth order spline fit in stage B.}

\item{\code{Stored}}{Matrix containing the knot locations estimated at each iteration
of stage A.}

\item{\code{Args}}{list containing the input arguments passed on the
\code{\link{Fitters}} functions.}

\item{\code{Call}}{\code{call} to the \code{\link{Fitters}} functions.}

\item{\code{Nintknots}}{the final number of internal knots of the second order GeD
spline fit produced in stage A.}

\item{\code{iters}}{number of iterations performed during stage A of the GeDS fitting
procedure.}

\item{\code{Guesses}}{initial values for the coefficients used at each iteration of
stage A in order to estimate the spline coefficients. Since the initial
values are used only in the IRLS procedure, this slot is empty if the object
is not created by \code{\link{GGeDS}} or \code{\link{GenUnivariateFitter}}
functions.}

\item{\code{Coefficients}}{matrix containing the fitted coefficients of the GeD
spline regression component and the parametric component at each iteration
of stage A.}

\item{\code{deviance}}{vector containing the deviances of the second order spline
fits computed at each IRLS iteration in stage A. Since the IRLS procedure is
used only in \code{\link{GGeDS}} or \code{\link{GenUnivariateFitter}}, this
slot is empty if the object is not created by one of these functions.}

\item{\code{iterIrls}}{vector containing the numbers of IRLS iterations for all
iterations of stage A cumulatively. Since the IRLS procedure is used only in
\code{\link{GGeDS}} or \code{\link{GenUnivariateFitter}}, this slot is empty
if the object is not created by one of these functions.}

\item{\code{stopinfo}}{list of values providing information related to the stopping
rule of stage A of GeDS. The sub-slots of \code{stopinfo} are \code{phis},
\code{phis_star}, \code{oldintc} and \code{oldslp}. The sub-slot \code{phis}
is a vector containing the values of the ratios of deviances (or the
difference of deviances if the \code{LR} stopping rule was chosen). The
sub-slots \code{phis_star}, \code{oldintc} and \code{oldslp} are non-empty
slots if the \code{SR} stopping rule was chosen. These respectively contain
the values at each iteration of stage A of \eqn{\hat{\phi}_{\kappa}},
\eqn{\hat{\gamma}_0} and \eqn{\hat{\gamma}_1}. See Dimitrova et al. (2023)
for further details on these parameters.}

\item{\code{Formula}}{the model \code{\link[=formula.GeDS]{formula}}.}

\item{\code{extcall}}{\code{call} to the \code{\link{NGeDS}} or \code{\link{GGeDS}}
functions.}

\item{\code{terms}}{\code{terms} object containing information on the model frame.}
}}

\references{
Dimitrova, D. S., Kaishev, V. K., Lattuada, A. and Verrall, R. J.  (2023).
Geometrically designed variable knot splines in generalized (non-)linear
models.
\emph{Applied Mathematics and Computation}, \strong{436}. \cr
DOI: \doi{10.1016/j.amc.2022.127493}
}
