\name{getWhiteCOEF}
\alias{getWhiteCOEF}

\title{Extract country-specific LS coefficient estimates with White robust covariance.
}

\encoding{latin1}


\description{Extract country-specific LS coefficient estimates with White robust covariance.
}

\usage{getWhiteCOEF(out,sheet)
}

\arguments{
  \item{out}{A list object of estimation results generated by GVARest.
}
  \item{sheet}{The number of country in out that is to be saved.
}

}

\value{
  \item{coef}{Country-specific coefficient estimates.}
}
\author{Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.
}

\examples{
data("PriceVol")
data("tradeweight1")
data("tradeweightx")
p=2
FLag=2
lag.max=15
type="const"
ic="SC"
weight.matrix=tradeweightx
mainOUTPUT = GVARest(data=PriceVol,p,FLag,lag.max,type,ic,weight.matrix)

COEF=getWhiteCOEF(out=mainOUTPUT,sheet=1)

}

