% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_grid.R
\name{r.grid}
\alias{r.grid}
\title{Generates a random sample from a grid type copula}
\usage{
r.grid(n, gc)
}
\arguments{
\item{n}{an integer number indicating the size of the sample.}

\item{gc}{a grid type copula object.}
}
\value{
Returns a  matrix of size nx2 with the random sample.
}
\description{
Generates a random sample from a grid type copula
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 15
m <- 15
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
df2 <- r.grid(n = n, gc = copula.grid)
data.grid(df, k=k, m=m)
data.grid(df2, k=k, m=m)
}
