% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipartiteBM.R
\name{multipartiteBM}
\alias{multipartiteBM}
\title{Model selection and parameter estimation of MBM}
\usage{
multipartiteBM(
  list_Net,
  v_distrib = NULL,
  namesFG = NULL,
  v_Kmin = 1,
  v_Kmax = 10,
  v_Kinit = NULL,
  initBM = TRUE,
  keep = FALSE,
  verbose = TRUE,
  nbCores = NULL,
  maxiterVE = NULL,
  maxiterVEM = NULL
)
}
\arguments{
\item{list_Net}{a list of networks (defined via the function defineNetwork) i.e. a multipartite network}

\item{v_distrib}{an optional vector of characters of length the number of networks and specifying the distribution used in each network (possible values \code{bernoulli,poisson,gaussian,laplace}).   If not provided, the model will be 'bernoulli' for all the interactions  matrices.}

\item{namesFG}{an optional vector of  characters containing the names of functional groups (FG) (If Specified, must correspond to the  names in \code{list_Net}).}

\item{v_Kmin}{an optional vector of integers, specifying the minimal number of blocks per functional group (must be provided in the same order as in \code{namesFG}).
v_Kmin may be a single value (same minimal number of blocks for all the FGs) or a vector with size equal to the number of FGs.
Default value  \code{= 1}.}

\item{v_Kmax}{an optional vector of integers specifying the maximal number of blocks per functional group provided in the same order as in \code{namesFG}.
v_Kmax may be a single value (same maximal number of blocks for all the FGs) or a vector with size equal to the number of FGs.
Default value  \code{= 10}.}

\item{v_Kinit}{an optional vector of integers specifying initial numbers of blocks per FG provided in the same order as in \code{namesFG}.
if \code{v_Kinit} is not specified, then   \code{v_Kinit = v_Kmin}}

\item{initBM}{an optional boolean. If initBM = TRUE  an aditional initialisation is done using simple LBM or SBM on each network separatly.
Default value  \code{= TRUE}}

\item{keep}{an optional boolean. If TRUE  return the estimated parameters for intermediate visited models. Otherwise, only the better model (in ICL sense) is the ouput. Default value \code{= FALSE}.}

\item{verbose}{an optional boolean. If  TRUE, display the current step of the search algorithm}

\item{nbCores}{an optional integer specifying the number or cores used for the estimation. Not parallelized on windows. If \code{ncores = NULL}, then half of the cores are used.}

\item{maxiterVE}{an optional integer  specifying the maximum number of iterations in the VE step of the VEM algorithm. If NULL then default value  \code{= 1000}}

\item{maxiterVEM}{an optional integer  specifying the maximum number of iterations of the VEM algorithm. If NULL then default value Default value  \code{= 1000}}
}
\value{
a list of estimated parameters for the different models ordered by decreasing ICL. If keep \code{= FALSE}, the length is of length 1 (only the better model is returned).
\describe{
\item{\code{fittedModel}}{contains the results of the inference. \code{res$fittedModel[[1]]}  is a list with fields
\describe{
\item{\code{paramEstim}}{a MBMfit object.}
\item{\code{ICL}}{the penalized likelihood criterion ICL.}
\item{\code{vJ}}{the sequence of the varational bound of the likelihood through iterations of the VEM.}
\item{\code{convergence}}{TRUE if the VEM reached convergence.}
}
}
\item{\code{list_Net}}{ contains the data.}
}
}
\description{
Select the number of blocks and identify the blocks per functional group using a variational EM algorithm
}
\details{
The function \code{multipartiteBM} selects the better numbers of blocks in each FG (with a penalized likelihood criterion). The model selection is performed with a forward backward strategy and the likelihood of each model is maximized with a variational EM).
}
\examples{
namesFG <- c('A','B')
list_pi <- list(c(0.5,0.5),c(0.3,0.7)) # prop of blocks in each FG
E  <-  rbind(c(1,2),c(2,2)) # architecture of the multipartite net.
typeInter <- c( "inc","diradj")
v_distrib <- c('gaussian','bernoulli')
list_theta <- list()
list_theta[[1]] <- list()
list_theta[[1]]$mean  <- matrix(c(6.1, 8.9, 6.6, 3), 2, 2)
list_theta[[1]]$var  <-  matrix(c(1.6, 1.6, 1.8, 1.5),2, 2)
list_theta[[2]] <- matrix(c(0.7,1.0, 0.4, 0.6),2, 2)
list_Net <- rMBM(v_NQ = c(30,30),E , typeInter, v_distrib, list_pi,
                list_theta, namesFG = namesFG, seed = 2)$list_Net
res_MBMsimu <- multipartiteBM(list_Net, v_distrib,
                              namesFG = c('A','B'), v_Kinit = c(2,2),
                              nbCores = 2,initBM = FALSE)
}
