% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPACox.R
\name{GRAB.SPACox}
\alias{GRAB.SPACox}
\title{SPACox method in GRAB package}
\usage{
GRAB.SPACox()
}
\value{
No return value, called for side effects (prints information about the SPACox method to the console).
}
\description{
SPACox method is an empirical approach to analyzing complex traits (including but not limited to time-to-event trait) for unrelated samples in a large-scale biobank.
}
\details{
Additional list of \code{control} in \code{GRAB.NullModel()} function.

Additional list of \code{control} in \code{GRAB.Marker()} function.
}
\examples{
# Step 1: fit a null model
PhenoFile <- system.file("extdata", "simuPHENO.txt", package = "GRAB")
PhenoData <- data.table::fread(PhenoFile, header = TRUE)
obj.SPACox <- GRAB.NullModel(
  survival::Surv(SurvTime, SurvEvent) ~ AGE + GENDER,
  data = PhenoData,
  subjData = IID,
  method = "SPACox",
  traitType = "time-to-event"
)

# Using model residuals performs exactly the same as the above. Note that
# confounding factors are still required in the right of the formula.
obj.coxph <- survival::coxph(
  survival::Surv(SurvTime, SurvEvent) ~ AGE + GENDER,
  data = PhenoData,
  x = TRUE
)

obj.SPACox <- GRAB.NullModel(
  obj.coxph$residuals ~ AGE + GENDER,
  data = PhenoData,
  subjData = IID,
  method = "SPACox",
  traitType = "Residual"
)

# Step 2: conduct score test
GenoFile <- system.file("extdata", "simuPLINK.bed", package = "GRAB")
OutputDir <- tempdir()
OutputFile <- file.path(OutputDir, "Results_SPACox.txt")
GRAB.Marker(
  objNull = obj.SPACox,
  GenoFile = GenoFile,
  OutputFile = OutputFile,
  control = list(outputColumns = "zScore")
)
data.table::fread(OutputFile)

}
