% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visuEq.R
\name{visuEq}
\alias{visuEq}
\title{Displays the models Equations}
\usage{
visuEq(nVar, dMax, K, substit = 0, approx = FALSE)
}
\arguments{
\item{nVar}{The number of variables}

\item{dMax}{The maximum degree allowed in the formulation}

\item{K}{A matrix providing the model description:
each column corresponds to one equation which polynomial organisation
is following the convention defined by function \code{poLabs}.}

\item{substit}{Applies subtitutions to the default values:
for \code{substit = 0} (default value), variables are chosen
as \code{X1}, \code{X2}, ...
for \code{substit = 1}, variable \code{X1}, \code{X2}, ...
will be replaced by \code{x}, \code{y}, \code{z}, ...
for \code{substit = 2}, the codes provides a LaTex-like
formulation of the model.
The variables name can also be defined explicitely as follows:
for \code{substit = c('x', 'H', 'T1')}, variables \code{X1},
\code{X2}, \code{X3} ... will be replaced by \code{x}, \code{H}
and \code{T1}.}

\item{approx}{The number of extra digits to be used:
for \code{approx = FALSE} (default value) digits are
edited with double precision;
for \code{approx = TRUE}, only the minimum number of digits is
edited (in order to have all the terms different from 0)
for \code{approx} = 1, 2, etc. then respectively 1, 2, etc.
digits are added to the minimum number of digits corresponding
to \code{approx = TRUE}.}
}
\description{
Displays the model equations for a polynomial model
which description is provided as a matrix \code{K}, each column
corresponding to one equation. The coefficients of the polynomial terms are given
following the order defined by function \code{poLabs}.
}
\examples{
#EQUATIONS VISUALISATION
# number of variables:
nVar <- 3
# maximum polynomial degree:
dMax <- 2
# polynomial organization:
poLabs(nVar,dMax)
# model construction
KL = matrix(0, ncol = 3, nrow = 10)
KL[1,1] <- KL[2,2] <- 1
KL[4,1] <- -1
KL[5,3] <- -0.123456789
# Equations visualisation:
# (a) by default, variables names X1, X2, X3 are used
visuEq(nVar, dMax, KL)
# (b) for susbstit=1, variables names x, y, y are used instead
visuEq(nVar, dMax, KL, approx = TRUE, substit=1)
# (c) the name of the variables can also be chosen manualy
visuEq(nVar, dMax, KL, approx = 3, substit=c('U', 'V', 'W'))

# A canonical model can be provided as a single vector
polyTerms <- c(0.2,0,-1,0.5,0,0,0,0,0,0)
visuEq(3,2,KL)

}
\author{
Sylvain Mangiarotti
}
