% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgp.functions.R
\name{plot.mgpr}
\alias{plot.mgpr}
\title{Plot predictions of GPR model}
\usage{
\method{plot}{mgpr}(
  x,
  DataObs,
  DataNew,
  realisation,
  alpha = 0.05,
  ylim = NULL,
  mfrow = NULL,
  cex = 2,
  mar = c(4.5, 7.1, 0.2, 0.8),
  oma = c(0, 0, 0, 0),
  cex.lab = 2,
  cex.axis = 1.5,
  ...
)
}
\arguments{
\item{x}{An object of class 'mgpr'.}

\item{DataObs}{List of observed data.}

\item{DataNew}{List of test data.}

\item{realisation}{Index identifying which realisation should be plotted.}

\item{alpha}{Significance level used for MGPR predictions. Default is 0.05.}

\item{ylim}{Range of y-axis.}

\item{mfrow}{Graphical parameter.}

\item{cex}{Graphical parameter.}

\item{mar}{Graphical parameter passed to par().}

\item{oma}{Graphical parameter passed to par().}

\item{cex.lab}{Graphical parameter passed to par().}

\item{cex.axis}{Graphical parameter passed to par().}

\item{...}{Graphical parameters passed to plot().}
}
\value{
A plot showing predictions of each element of the multivariate
  process.
}
\description{
Plot predictons of each element of the multivariate Gaussian Process for a
given an object of class 'mgpr'.
}
\examples{
## See examples in vignette:
# vignette("mgpr", package = "GPFDA")
}
