% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cauchy}
\alias{cauchy}
\title{The generalized Cauchy correlation function}
\usage{
cauchy(d, range, tail, nu)
}
\arguments{
\item{d}{a matrix of distances}

\item{range}{a numerical value containing the range parameter}

\item{tail}{a numerical value containing the tail decay parameter}

\item{nu}{a numerical value containing the smoothness parameter}
}
\value{
a numerical matrix
}
\description{
This function computes the generalized Cauchy correlation function given
a distance matrix. The generalized Cauchy covariance is given by
\deqn{C(h) = \left\{ 1 + \left( \frac{h}{\phi} \right)^{\nu}  
            \right\}^{-\alpha/\nu},}
where \eqn{\phi} is the range parameter. \eqn{\alpha} is the tail decay parameter.
\eqn{\nu} is the smoothness parameter. 
The case where \eqn{\nu=2} corresponds to the Cauchy covariance model, which is infinitely differentiable.
}
\seealso{
\code{\link{kernel}}
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
