% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visdag.R
\name{visRsubDAGCC}
\alias{visRsubDAGCC}
\title{Visualise the GO-DAG for a specific organism based on certain GO-terms}
\usage{
visRsubDAGCC(goterm, organism)
}
\arguments{
\item{goterm}{A vector of cellular component GO-terms}

\item{organism}{The organism whose DAG we want to visualise based on the GO-terms supplied}
}
\value{
Returns a plot highlighting the important categories i.e. the categories containing the GO-terms of interest.
                 If this argument is "CC"
                the general reduced GO CC tree is used.
}
\description{
A category in the organism-specific DAG is regarded as important if it contains at least one GO-terms from
             the vector given. The function does not visualise the entire organism's DAG, it accepts a range of GO-terms and DAG
             categories that contains
             these GO-terms are visualise. We refer to these categories as the important and everything else is faded out.
             The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse",
             "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{

# Visualised Human GO-DAG based on the GO-terms given
Terms <- c("GO:0030054","GO:0045171","GO:0043204")

visRsubDAGCC(goterm = Terms, organism = "Human")

}
