% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.ts.ng.studyend.criteria.r
\name{make.ts.ng.studyend.criteria}
\alias{make.ts.ng.studyend.criteria}
\title{Create lookup table for study-end}
\usage{
make.ts.ng.studyend.criteria(
  mu.0.c = 0,
  alpha.0.c = 0.25,
  beta.0.c = 1,
  n.0.c = 1,
  mu.0.t = 0,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  n.0.t = 1,
  xbar.c.LB = 0,
  xbar.c.UB = 5,
  npoints = 6,
  s.c = 7,
  n.c = 55,
  xbar.t = 0,
  s.t = 7,
  n.t = 55,
  Delta.lrv = 5.5,
  Delta.tv = 6.5,
  tau.ng = 0.65,
  tau.lrv = 0.8,
  tau.tv = 0.1,
  n.MC = 250,
  go.parallel = TRUE,
  cl = cl
)
}
\arguments{
\item{mu.0.c}{prior parameter, mean, control}

\item{alpha.0.c}{prior parameter, precision, alpha, control}

\item{beta.0.c}{prior parameter, precision, beta, control}

\item{n.0.c}{prior parameter, effective sample size, control}

\item{mu.0.t}{prior parameter, mean, treatment}

\item{alpha.0.t}{prior parameter, precision, alpha, treatment}

\item{beta.0.t}{prior parameter, precision, beta, treatment}

\item{n.0.t}{prior parameter, effective sample size, treatment}

\item{xbar.c.LB}{lowerbound for xbar on control}

\item{xbar.c.UB}{upperbound for xbar on control}

\item{npoints}{number of points}

\item{s.c}{sample sd, control}

\item{n.c}{sample size, control}

\item{xbar.t}{sample mean - treatment}

\item{s.t}{sample sd, treatment}

\item{n.t}{sample size, treatment}

\item{Delta.lrv}{TTP info}

\item{Delta.tv}{TTP info}

\item{tau.ng}{thresholds}

\item{tau.lrv}{thresholds}

\item{tau.tv}{thresholds}

\item{n.MC}{MC size}

\item{go.parallel}{logical to engage parallel computing}

\item{cl}{cluster}
}
\value{
A data.frame is returned
}
\description{
Create lookup table for study-end
}
\examples{
\donttest{
make.ts.ng.studyend.criteria(go.parallel=FALSE)
}
}
