% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.ss.ng.ria.r
\name{make.ss.ng.ria}
\alias{make.ss.ng.ria}
\title{Make single sample normal-gamma rule in action plot}
\usage{
make.ss.ng.ria(
  mu.0.t = 0,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  n.0.t = 1,
  xbar.t = -0.05,
  s.t = 3,
  n.t = 10,
  Delta.lrv = 0,
  Delta.tv = 1,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  tsize = 4,
  nlines = 25,
  nlines.ria = 20,
  add.table = TRUE
)
}
\arguments{
\item{mu.0.t}{prior mean}

\item{alpha.0.t}{prior alpha parameter}

\item{beta.0.t}{prior beta parameter}

\item{n.0.t}{prior effective sample size}

\item{xbar.t}{observed sample mean}

\item{s.t}{observed sample standard deviation}

\item{n.t}{sample size}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{tsize}{Control for text size}

\item{nlines}{Control for text spacing}

\item{nlines.ria}{Control for text spacing}

\item{add.table}{provides extended output summaries}
}
\value{
A ggplot object is returned
}
\description{
Make single sample normal-gamma rule in action plot
}
\examples{
\donttest{
my.ss.ng.ria <- make.ss.ng.ria(add.table=TRUE)
plot(my.ss.ng.ria[[1]])
my.ss.ng.ria[[2]]
my.ss.ng.ria[[3]]
my.ss.ng.ria[[4]]
}
}
