% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.ng.mc.df.r
\name{get.ts.ng.mc.df}
\alias{get.ts.ng.mc.df}
\title{Get two-sample normal-gamma MC-based data.frame}
\usage{
get.ts.ng.mc.df(
  mu.0.c = 0,
  n.0.c = 10,
  alpha.0.c = 0.25 * 4,
  beta.0.c = 1 * 4,
  xbar.c = seq(-3, 3, length.out = 20),
  s.c = 3,
  n.c = 25,
  group.c = "Control",
  mu.0.t = 0,
  n.0.t = 10,
  alpha.0.t = 0.25 * 4,
  beta.0.t = 1 * 4,
  xbar.t = seq(0, 6, length.out = 20),
  s.t = 2,
  n.t = 25,
  group.t = "Treatment",
  Delta.tv = 1.75,
  Delta.lrv = 1.5,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0,
  n.MC = 1000,
  seed = 1234,
  expand = TRUE
)
}
\arguments{
\item{mu.0.c}{prior mean for control group}

\item{n.0.c}{prior effective sample size for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{xbar.c}{sample mean for control group}

\item{s.c}{sample sd for control group}

\item{n.c}{sample size for control group}

\item{group.c}{group label for control group}

\item{mu.0.t}{prior mean for treatment group}

\item{n.0.t}{prior effective sample size for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{xbar.t}{sample mean for treatment group}

\item{s.t}{sample sd for treatment group}

\item{n.t}{sample size for treatment group}

\item{group.t}{group label for treatment group}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{n.MC}{number of MC sampling}

\item{seed}{random seed}

\item{expand}{logical; if true expand.grid is employed; else data.frame is employed. Former provides all combinations}
}
\value{
A data.frame is returned
}
\description{
Get two-sample normal-gamma MC-based data.frame
}
\examples{
my.ts.ng.mc.df <- get.ts.ng.mc.df()
my.ts.ng.mc.df

}
