% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMcat2.R
\name{glmcat}
\alias{glmcat}
\title{Generalized linear models for categorical responses}
\usage{
glmcat(
  formula,
  data,
  ratio = c("reference", "cumulative", "sequential", "adjacent"),
  cdf = list(),
  parallel = NA,
  categories_order = NA,
  ref_category = NA,
  threshold = c("standard", "symmetric", "equidistant"),
  control = list(),
  normalization = 1,
  ...
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit. An expression of the form y ~ predictors is interpreted as a specification that the response y is modelled by a linear predictor specified symbolically by model.}

\item{data}{a dataframe object in R, with the dependent variable as factor.}

\item{ratio}{a string indicating the ratio (equivalently to the family) options are: reference, adjacent, cumulative and sequential. Default value is reference.}

\item{cdf}{\describe{
The inverse distribution function to be used as part of the link function.
If the distribution has no parameters to specify then it should be entered as a
string indicating the name, e.g., \code{cdf = "normal"}, the default value is \code{cdf = "logistic"}.
If there are parameters to specify then a list must be entered,
so far this would only be the case for Student's distribution which would be
\code{list("student", df=2)},
and for the non-central distribution of student, \code{list("noncentralt", df=2, mu=1)},
}}

\item{parallel}{a character vector indicating the name of the variables with a parallel effect. If variable is categorical, specify the name and the level of the variable as a string "namelevel".}

\item{categories_order}{a character vector indicating the incremental order of the categories: c("a", "b", "c"); a<b<c. Alphabetical order is assumed by default. Order is relevant for adjacent, cumulative and sequential ratio.}

\item{ref_category}{a string indicating the reference category. Proper option for models with reference ratio.}

\item{threshold}{restriction to impose on the thresholds, options are: standard, equidistant or symmetric (Valid only for the cumulative ratio).}

\item{control}{\describe{
\item{\code{maxit}:}{the maximum number of iterations for the Fisher scoring algorithm.}
\item{\code{epsilon}:}{a double to change update the convergence criterion of GLMcat models.}
\item{\code{beta_init}:}{an appropriate sized vector for the initial iteration of the algorithm.}
}}

\item{normalization}{the quantile to use for the normalization of the estimated coefficients where the logistic distribution is used as the base cumulative distribution function.}

\item{...}{additional arguments.}
}
\description{
Estimate generalized linear models implemented under the unified
specification ( ratio,cdf,Z) where \code{ratio} represents the ratio of probabilities
(reference, cumulative, adjacent, or sequential), \code{cdf} the cumulative distribution function
for the linkage, and Z the design matrix which must be specified through the \code{parallel}
and the \code{threshold} arguments.
}
\details{
Fitting models for categorical responses
}
\examples{
data(DisturbedDreams)
ref_log_com <- glmcat(formula = Level ~ Age, data = DisturbedDreams,
    ref_category = "Very.severe",
    cdf = "logistic", ratio = "reference")
}
\references{
Peyhardi J, Trottier C, Guédon Y (2015). “A new specification of generalized linear models
 for categorical responses.” \emph{Biometrika}, 102(4), 889–906. doi:10.1093/biomet/asv042.
}
