% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gacos_correction.R
\name{GACOS.PhCor}
\alias{GACOS.PhCor}
\title{GACOS Atmospheric Phase delay correction}
\usage{
GACOS.PhCor(
  unw_pha,
  re_dztd,
  wavelength = "in meter",
  inc_ang = 90,
  ref_lat = NA,
  ref_lon = NA
)
}
\arguments{
\item{unw_pha}{Un-wrapped InSAR tile/raster.}

\item{re_dztd}{Resampled Di-ZTD.}

\item{wavelength}{SAR wavelength in meter.}

\item{inc_ang}{SAR incident angle (to get output in LOS direction, don't use if not needed).}

\item{ref_lat}{A reference point for correction, If NA, It use the tile center latitude.}

\item{ref_lon}{A reference point for correction, If NA, It use the tile center longitude.}
}
\description{
GACOS Atmospheric Phase delay correction
}
\examples{
library(raster)
library(GInSARCorW)
library(circular)
noDataAsNA<-FALSE
i1m<-system.file("td","20170317.ztd.rsc",package = "GInSARCorW")
i2m<-system.file("td","20170410.ztd.rsc",package = "GInSARCorW")
GACOS_ZTD_T1<-GACOS.Import(i1m,noDataAsNA)
GACOS_ZTD_T2<-GACOS.Import(i2m,noDataAsNA)
dztd<-d.ztd(GACOS_ZTD_T1,GACOS_ZTD_T2)
unw_pha<-raster(system.file("td","Unw_Phase_ifg_17Mar2017_10Apr2017_VV.img",package = "GInSARCorW"))
crs(unw_pha)<-CRS("+proj=longlat +datum=WGS84 +no_defs")
re_dztd<-d.ztd.resample(unw_pha,dztd)
GACOS.PhCor(unw_pha,re_dztd,0.055463,inc_ang=39.16362,ref_lat=NA,ref_lon=NA)
}
\author{
Subhadip Datta
}
