% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphfanova.r
\name{frank.fanova2d}
\alias{frank.fanova2d}
\title{Rank envelope F-test for images}
\usage{
frank.fanova2d(nsim, image_set, groups, ...)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{image_set}{A set of images containing the data, see \code{\link{create_image_set}}.}

\item{groups}{The original groups (a factor vector representing the assignment to groups).}

\item{...}{Additional parameters to be passed to \code{\link{frank.fanova}}.}
}
\description{
Rank envelope F-test for images
}
\details{
A one-way functional ANOVA for images (2d functions), based on the rank envelope applied to
F values.
This function can be used to perform F-rank one-way functional ANOVA tests described
in Mrkvička et al. (2018). The function transforms images to vectors (1d), calls
\code{\link{frank.fanova}} and transform results back to images (2d).
}
\examples{
\donttest{
data("imageset1")
res <- frank.fanova2d(nsim = 19, # Increase nsim for serious analysis!
                      image_set = imageset1$image_set,
                      groups = imageset1$Group)
plot(res)
plot(res, fixedscales=FALSE, contours=FALSE)
}
}
\references{
Mrkvička, T., Myllymäki, M., Jilek, M. and Hahn, U. (2018)
A one-way ANOVA test for functional data with graphical interpretation.
arXiv:1612.03608 [stat.ME] (http://arxiv.org/abs/1612.03608)
}
