#' @title A Function generate edge prediction plots.
#' @description Plots edgewise predictions generated by the
#' `conditional_edge_prediction()` function.
#'
#' @param edge_prediction_results A list object returned by the
#' `conditional_edge_prediction()` function.
#' @param filename The name of the file the user would like to save the plots in.
#' Should be something along the lines of "edge_plots.pdf"
#' @param plot_size A single number specifying the dimensions of the PDF output
#' file. This will automatically be square so only one number is required.
#' @param node_name_cex The cex for node names (printed on the diagonal).
#' Defaults to 1, but can be increased to make these easier to see.
#' @return Saves a PDF plot to the current working directory
#' @export
conditional_edge_prediction_plot <- function(edge_prediction_results,
                                             filename,
                                             plot_size,
                                             node_name_cex = 1) {

  observed_network <- edge_prediction_results$observed_network
  num_nodes <- nrow(observed_network)
  Edge_Predictions <- edge_prediction_results$edge_predictions

  UMASS_BLUE <- rgb(51,51,153,155,maxColorValue = 255)
  UMASS_RED <- rgb(153,0,51,255,maxColorValue = 255)

  # create the pdf
  pdf(file = filename, height = plot_size, width = plot_size)
  #bottom, left, top, and right
  par(mfrow = c(num_nodes,num_nodes),
      tcl=-0.5,
      mai=c(0.1,0.3,0.1,0.1))

  # loop and populate plot area
  for (i in 1:num_nodes) {
    for (j in 1:num_nodes) {
      if (i != j) {
        boxplot(Edge_Predictions[i,j,],
                medcol = UMASS_RED,
                xlab = "",
                ylab = "",
                main = "",
                xaxt = "n",
                las = 1)
        zero_plot <- rbind(observed_network[i,j],
                           observed_network[i,j])
        boxplot(zero_plot, add = T, medcol = UMASS_BLUE, names = F, axes = F)
      } else {
        plot.new()
        text(x= 0.5, y = 0.5,colnames(observed_network)[i],cex = node_name_cex)
      }
    }
  }

  dev.off()

}
