% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bic.PTReg.R
\name{bic.PTReg}
\alias{bic.PTReg}
\title{BIC for PTReg}
\usage{
bic.PTReg(
  G,
  E,
  Y,
  lambda1_set,
  lambda2_set,
  gamma1,
  gamma2,
  max_init,
  h = NULL,
  tau = 0.4,
  mu = 2.5,
  family = c("continuous", "survival")
)
}
\arguments{
\item{G}{Input matrix of \code{p} genetic (G) measurements consisting of \code{n} rows.
Each row is an observation vector.}

\item{E}{Input matrix of \code{q} environmental (E) risk factors. Each row is an
observation vector.}

\item{Y}{Response variable. A quantitative vector for \code{family="continuous"}.
For \code{family="survival"}, \code{Y} should be a two-column matrix with the first column being
the log(survival time) and the second column being the censoring indicator. The indicator is a
binary variable, with "1" indicating dead, and "0" indicating right censored.}

\item{lambda1_set}{A user supplied lambda sequence for minimax concave penalty (MCP)
accommodating main G effect selection.}

\item{lambda2_set}{A user supplied lambda sequence for MCP accommodating interaction selection.}

\item{gamma1}{The regularization parameter of the MCP penalty corresponding to G effects.}

\item{gamma2}{The regularization parameter of the MCP penalty corresponding to G-E interactions.}

\item{max_init}{The number of initializations.}

\item{h}{The number of the trimmed samples if the parameter \code{mu} is not given.}

\item{tau}{The threshold value used in stability selection.}

\item{mu}{The parameter for screening outliers with extreme absolute residuals if the number of
the trimmed samples \code{h} is not given.}

\item{family}{Response type of \code{Y} (see above).}
}
\value{
An object with S3 class \code{"bic.PTReg"} is returned, which is a list with the ingredients of the BIC fit.
\item{call}{The call that produced this object.}
\item{alpha}{The matrix of the coefficients for main E effects, each column corresponds to one
combination of (lambda1,lambda2).}
\item{beta}{The coefficients for main G effects and G-E interactions, each column corresponds to
one combination of (lambda1,lambda2). For each column, the first element is the first G effect and
the second to (\code{q+1}) elements are the interactions for the first G factor, and so on.}
\item{intercept}{Matrix of the intercept estimate, each column corresponds to one combination of
(lambda1,lambda2).}
\item{df}{The number of nonzeros for each value of (lambda1,lambda2).}
\item{BIC}{Bayesian Information Criterion for each value of (lambda1,lambda2).}
\item{family}{The same as input \code{family}.}
\item{intercept_estimate}{Final intercept estimate using Bayesian Information Criterion.}
\item{alpha_estimate}{Final alpha estimate using Bayesian Information Criterion.}
\item{beta_estimate}{Final beta estimate using Bayesian Information Criterion.}
\item{lambda_combine}{Matrix of (lambda1, lambda2), with the first column being the values of
lambda1, the second being the values of lambda2.}
}
\description{
Selects a point along the regularization path of a fitted \code{PTReg} object according to
the BIC.
}
\examples{
sigmaG<-AR(rho=0.3,p=30)
sigmaE<-AR(rho=0.3,p=3)
set.seed(300)
G=MASS::mvrnorm(150,rep(0,30),sigmaG)
EC=MASS::mvrnorm(150,rep(0,2),sigmaE[1:2,1:2])
ED = matrix(rbinom((150),1,0.6),150,1)
E=cbind(EC,ED)
alpha=runif(3,0.8,1.5)
beta=matrix(0,4,30)
beta[1,1:4]=runif(4,1,1.5)
beta[2,c(1,2)]=runif(2,1,1.5)
lambda1_set=lambda2_set=c(0.2,0.25,0.3,0.35,0.4,0.5)

\donttest{
#continuous response with outliers/contaminations in response variable
y1=simulated_data(G,E,alpha,beta,error=c(rnorm(140),rcauchy(10,0,5)),family="continuous")
fit1<-bic.PTReg(G,E,y1,lambda1_set,lambda2_set,gamma1=6,gamma2=6,
max_init=50,tau=0.6,mu=2.5,family="continuous")
coefficients1=coefficients(fit1)
y_predict=predict(fit1,E,G)
plot(fit1)

# survival with Normal error
y2=simulated_data(G,E,alpha,beta,rnorm(150,0,1),family="survival",0.7,0.9)
fit2<-bic.PTReg(G,E,y2,lambda1_set,lambda2_set,gamma1=6,gamma2=6,
max_init=50,tau=0.6,mu=2.5,family="survival")
coefficients2=coefficients(fit2)
y_predict=predict(fit2,E,G)
plot(fit2)
}
}
\references{
Yaqing Xu, Mengyun Wu, Shuangge Ma, and Syed Ejaz Ahmed.
\emph{Robust gene-environment interaction analysis using penalized trimmed regression. Journal of
Statistical Computation and Simulation, 88(18):3502-3528, 2018.}
}
