% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemIntertemporal_Bank_1_3.R
\name{gemIntertemporal_Bank_1_3}
\alias{gemIntertemporal_Bank_1_3}
\title{Some Examples of an Intertemporal Model with Two Consumers and a Type of Bank}
\usage{
gemIntertemporal_Bank_1_3(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
Some examples of an intertemporal model with two consumers and a type of bank.
}
\examples{
\donttest{
#### an example with a 5-period-lived consumer
np <- 5 # the number of periods

interest.rate <- 0.1
S <- matrix(NA, np, np+1)
S[1:np, np] <- 100/(np:1)
S[1:np, np+1] <- 100/(1:np)

B <- matrix(0, np, np+1)
B[2:np, 1:(np-1)] <- diag(np-1)

dstl.bank <- list()
for (k in 1:(np-1)) {
  dstl.bank[[k]] <- node_new(
    "output",
    type = "Leontief",
    a = 1/(1+interest.rate),
    paste0("payoff", k)
  )
}

dst.consumer1 <- node_new(
  "util",
  type = "SCES",
  es = 1, alpha = 1,
  beta = prop.table(1:np),
  paste0("payoff", 1:np)
)

dst.consumer2 <- node_new(
  "util",
  type = "SCES",
  es = 1, alpha = 1,
  beta = prop.table(np:1),
  paste0("payoff", 1:np)
)

ge <- sdm2(
  A = c(dstl.bank, dst.consumer1, dst.consumer2),
  B = B,
  S0Exg = S,
  names.commodity = paste0("payoff", 1:np),
  names.agent = c(paste0("bank", 1:(np-1)), "consumer1","consumer2"),
  numeraire = "payoff1",
  policy = makePolicyMeanValue(30),
  ts = TRUE
)

ge$p
ge$z
ge$D
ge$S
ge$DV
ge$SV
growth_rate(ge$p)

##
dst.consumer1$es <- 0
dst.consumer1$beta <- rep(1/np, np)

ge <- sdm2(
  A = c(dstl.bank, dst.consumer1, dst.consumer2),
  B = B,
  S0Exg = S,
  names.commodity = paste0("payoff", 1:np),
  names.agent = c(paste0("bank", 1:(np-1)), "consumer1","consumer2"),
  numeraire = "payoff1",
  policy = makePolicyMeanValue(30),
  ts = TRUE
)

ge$p
ge$z
ge$D
ge$S
ge$DV
ge$SV
growth_rate(ge$p)
}
}
\seealso{
{
\code{\link{gemIntertemporal_Bank_1_2}}
}
}
