% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBOP2_minSS_singleE.gbop2.R
\name{GBOP2_minSS_singleE}
\alias{GBOP2_minSS_singleE}
\title{PSOGO: Optimal/Minimax design with single boundary for futility}
\usage{
GBOP2_minSS_singleE(
  design = "optimal",
  unified.u = 1,
  weight = 1,
  nlooks = 2,
  p0 = 0.2,
  p1 = 0.4,
  err1 = 0.05,
  minPower = 0.8,
  maxPatients = 5,
  Nmin_cohort1 = 1,
  Nmin_increase = 1,
  pso_method = "default",
  nParallel = NULL,
  seed = 456,
  nSwarm = 1,
  maxIter = 1
)
}
\arguments{
\item{design}{choose from "optimal", "minimax", or "unified"}

\item{unified.u}{specify when design = "unified", u in zero to one}

\item{weight}{weight of sample size under null}

\item{nlooks}{number of interim looks}

\item{p0}{Null hypothesis response rate}

\item{p1}{Alternative hypothesis response rate}

\item{err1}{Type I error rate}

\item{minPower}{power}

\item{maxPatients}{maximum number of patients}

\item{Nmin_cohort1}{minimum number of first cohort}

\item{Nmin_increase}{minimum number of increase in each cohort}

\item{pso_method}{"all" for using three distinct pso, otherwise indicate single pso method}

\item{nParallel}{number of pso ensemble}

\item{seed}{Random seed for reproducibility}

\item{nSwarm}{nSwarm for pso}

\item{maxIter}{maxIter for pso}
}
\value{
A list on design parameters and operating characteristics
}
\description{
This function implements PSOGO to find an optimal or minimax design with single boundary for futility.
}
\details{
Parallel computing is only used when the user explicitly sets nCore > 1. No more than 2 cores should be used
unless the user is aware and permits it. The function defaults to sequential execution. If multiple analyses
are planned, consider using \code{init_cluster(nCore)} and \code{stop_cluster()} manually to control the backend.
}
\examples{
\donttest{
# init_cluster(2)
#  GBOP2_minSS_singleE(
#   design = "optimal",
#    unified.u = 1,
#    nlooks = 1,
#    p0 = 0.2,
#    p1 = 0.4,
#    err1 = 0.05,
#    minPower = 0.8,
#    weight = 1,
#    maxPatients = 25,
#    Nmin_cohort1 = 10,
#    Nmin_increase = 5,
#    pso_method = "default",
#    nParallel = 3,
#    seed = 1024,
#    nSwarm = 64,
#    maxIter = 200
#  )
# stop_cluster()  # Only if init_cluster() was used
#  
message("Run GBOP2_minSS_singleE() manually for real optimization.")
}

}
