% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMANOVA_20122018.R
\name{FMANOVA}
\alias{FMANOVA}
\title{Computes a Mult-FANOVA model by a convenient metric, an exact calculation or an approximation}
\usage{
FMANOVA(
  formula,
  dataset,
  data.fuzzified,
  sig = 0.05,
  method,
  distance.type = "DSGD",
  index.var = NA,
  i = 1,
  j = 1,
  theta = 1/3,
  thetas = 1,
  p = 2,
  q = 0.5,
  breakpoints = 100,
  int.method = "int.simpson",
  plot = TRUE
)
}
\arguments{
\item{formula}{a description of the model to be fitted.}

\item{dataset}{the data frame containing all the variables of the model.}

\item{data.fuzzified}{the fuzzified data set constructed by a call to the function FUZZ or the function GFUZZ, or a similar matrix.}

\item{sig}{a numerical value representing the significance level of the test.}

\item{method}{the choices are the following: "distance", "exact", "approximation".}

\item{distance.type}{type of distance chosen from the family of distances. The different choices are given by: "Rho1", "Rho2", "Bertoluzza", "Rhop", "Delta.pq", "Mid/Spr", "wabl", "DSGD", "DSGD.G", "GSGD".}

\item{index.var}{the column index of the considered variable for which the output will be printed. It is an argument of the Mult-FANOVA models by the exact and the approximation methods only.}

\item{i}{parameter of the density function of the Beta distribution, fixed by default to i = 1.}

\item{j}{parameter of the density function of the Beta distribution, fixed by default to j = 1.}

\item{theta}{a numerical value between 0 and 1, representing a weighting parameter. By default, theta is fixed to 1/3 referring to the Lebesgue space. This measure is used in the calculations of the following distances: d_Bertoluzza, d_mid/spr and d_phi-wabl/ldev/rdev.}

\item{thetas}{a decimal value between 0 and 1, representing the weight given to the shape of the fuzzy number. By default, thetas is fixed to 1. This parameter is used in the calculations of the d_theta star and the d_GSGD distances.}

\item{p}{a positive integer such that 1 \eqn{\le} p < infinity, referring to the parameter of the Rho_p and Delta_pq. By default, p is fixed to 2.}

\item{q}{a decimal value between 0 and 1, referring to the parameter of the metric Delta_pq. By default, p is fixed to 0.5.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{int.method}{the method of numerical integration. It is set by default to the Simpson method, i.e. int.method="int.simpson".}

\item{plot}{fixed by default to "TRUE". plot="FALSE" if a plot of the fuzzy number is not required.}
}
\value{
Returns a list of all the arguments of the function, the total, treatment and residuals sums of squares, the coefficients of the model, the test statistics with the corresponding p-values, and the decision made.
}
\description{
Computes a Mult-FANOVA model by a convenient metric, an exact calculation or an approximation
}
\examples{
mat <- matrix(c(2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,3,4,4,3,1,2,5,4,4,3),ncol=3)
data <- data.frame(mat)
MF131 <- TrapezoidalFuzzyNumber(0,1,1,2)
MF132 <- TrapezoidalFuzzyNumber(1,2,2,3)
MF133 <- TrapezoidalFuzzyNumber(2,3,3,4)
MF134 <- TrapezoidalFuzzyNumber(3,4,4,5)
MF135 <- TrapezoidalFuzzyNumber(4,5,5,6)
PA13 <- c(1,2,3,4,5); mi <- 1; si <- 3
Yfuzz <- FUZZ(data,1,3,PA13)
attach(data)
formula <- X3 ~ X1 + X2
res <- FMANOVA(formula, data, Yfuzz, method = "distance", distance.type = "wabl")
detach(data)
}
