% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boot_ML_30012018.R
\name{boot.mean.ml}
\alias{boot.mean.ml}
\title{Estimates the bootstrap distribution of the likelihood ratio LR by the Algorithm 1 or 2 using the mean}
\usage{
boot.mean.ml(
  data.fuzzified,
  algorithm,
  distribution,
  sig,
  nsim = 100,
  mu = NA,
  sigma = NA,
  step = 0.1,
  margin = c(5, 5),
  breakpoints = 100,
  plot = TRUE
)
}
\arguments{
\item{data.fuzzified}{a fuzzification matrix constructed by a call to the function FUZZ or the function GFUZZ, 
or a similar matrix. No NA are allowed.}

\item{algorithm}{an algorithm chosen between "algo1" or "algo2".}

\item{distribution}{a distribution chosen between "normal", "poisson", "Student" or "Logistic".}

\item{sig}{a numerical value representing the significance level of the test.}

\item{nsim}{an integer giving the number of replications needed in the bootstrap procedure. It is set to 100 by default.}

\item{mu}{if the mean of the normal distribution is known, mu should be a numerical value. Otherwise, the argument mu is fixed to NA.}

\item{sigma}{if the standard deviation of the normal distribution is known, sigma should be a numerical value. Otherwise, the argument sigma is fixed to NA.}

\item{step}{a numerical value fixed to 0.1, defining the step of iterations on the interval [t-5; t+5].}

\item{margin}{an optional numerical couple of values fixed to [5; 5], representing the range of calculations around the parameter t.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{plot}{fixed by default to "FALSE". plot="FALSE" if a plot of the fuzzy number is not required.}
}
\value{
Returns a vector of decimals representing the bootstrap distribution of LR.
}
\description{
Estimates the bootstrap distribution of the likelihood ratio LR by the Algorithm 1 or 2 using the mean
}
\examples{
mat <- matrix(c(1,2,2,2,2,1),ncol=1)
MF111 <- TrapezoidalFuzzyNumber(0,1,1,2)
MF112 <- TrapezoidalFuzzyNumber(1,2,2,3)
PA11 <- c(1,2)
data.fuzzified <- FUZZ(mat,mi=1,si=1,PA=PA11) 
emp.dist <- boot.mean.ml(data.fuzzified, algorithm = "algo1", distribution = "normal",
 sig = 0.05, nsim = 5, sigma = 1)
eta.boot <- quantile(emp.dist,  probs = 95/100)
}
