% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetpc.R
\name{predict.FrechTree}
\alias{predict.FrechTree}
\title{Frechet Tree prediction}
\usage{
\method{predict}{FrechTree}(object, X, time, id, timeScale = 0.1, ...)
}
\arguments{
\item{object}{: Frechet tree obtained with the function \code{FrechTree}.}

\item{X}{[matrix]: a data frame or a matrix of trajectories predictors.}

\item{time}{[vector]: time measurements of the new trajectories to predict.}

\item{id}{[vector]: identifier, one for each trajectory to attribute each measurement of \code{X} to one of the trajectories.}

\item{timeScale}{[numeric]: allow to modify the time scale, increasing or decreasing the cost of the horizontal shift. If timeScale is very big, then the Frechet mean tends to the Euclidean distance. If timeScale is very small, then it tends to the Dynamic Time Warping.}

\item{...}{: optional parameters to be passed to the low level function.}
}
\value{
a matrix of  the identifier of the leaf (second column) in which each individual (first column) falls.
}
\description{
Given a Frechet tree and new input trajectories predictors \code{X}, this function returns the identifier of the leaf in which each observation falls.
}
\examples{
\dontrun{
set.seed(10)
data <- DataGenCurves(40)
Ft <- FrechTree(data$X,data$Y, data$id,data$time,select = "Hubert", toPlot="none")
}
}
