% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thf_tools.R
\name{thf_tools}
\alias{thf_tools}
\title{Temporal reconciliation tools}
\usage{
thf_tools(m, h = 1, sparse = TRUE)
}
\arguments{
\item{m}{Highest available sampling frequency per seasonal cycle (max. order of temporal aggregation, \mjseqn{m}),
or a subset of the \mjseqn{p} factors of \mjseqn{m}.}

\item{h}{Forecast horizon for the lowest frequency (most temporally aggregated) time series (\emph{default} is \mjseqn{1}).}

\item{sparse}{Option to return sparse object (\emph{default} is \code{TRUE}).}
}
\value{
A list of seven elements:
\item{\code{K}}{Temporal aggregation matrix.}
\item{\code{R}}{Temporal summing matrix.}
\item{\code{Zt}}{Zero constraints temporal kernel matrix, \mjseqn{\mathbf{Z}_h'\mathbf{Y}' =
\mathbf{0}_{\left[hk^* \times n \right]}}.}
\item{\code{kset}}{Set of factors (\mjseqn{p}) of \mjseqn{m} in descending order (from \mjseqn{m}
to 1), \mjseqn{{\cal K} = \left\lbrace k_p, k_{p-1}, \ldots, k_2, k_1\right\rbrace}, \mjseqn{k_p=m}, \mjseqn{k_1=1}.}
\item{\code{m}}{Highest available sampling frequency per seasonal cycle (max. order of temporal aggregation).}
\item{\code{p}}{Number of elements of kset, \mjseqn{{\cal K}}.}
\item{\code{ks}}{Sum of \mjseqn{p-1} factors of \mjseqn{m} (out of \mjseqn{m} itself), \mjseqn{k^*}.}
\item{\code{kt}}{Sum of all factors of m, \mjseqn{k^{tot} = k^*+m}.}
}
\description{
\loadmathjax
Some useful tools for forecast reconciliation through temporal hierarchies.
}
\examples{
# quarterly data
obj <- thf_tools(m = 4, sparse = FALSE)

}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{agg_ts}()},
\code{\link{arrange_hres}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{lcmat}()},
\code{\link{oct_bounds}()},
\code{\link{residuals_matrix}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()}
}
\concept{utilities}
\keyword{utilities}
