% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.cov.R
\name{pk.cov}
\alias{pk.cov}
\title{Center of Volume}
\usage{
pk.cov(TS, threshold.missing = 0.5)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{threshold.missing}{Numeric value indicating the fraction of data that can 
be missing in a single year. Years with a missing data above this threshold will have
NA values returned. Default is 0.5 (max of 50\% missing data allowed).}
}
\value{
Returns a data.frame with the following columns:
  \itemize{
    \item hYear - Hydrologic Years
    \item Q25 - day of hydrologic year for 25 percent of the total annual streamflow
    \item Q50 - day of hydrologic year for 50 percent of the total annual streamflow, i.e. Center of Volume
    \item Q75 - day of hydrologic year for 75 percent of the total annual streamflow
    \item Dur - duration of between the 25 percent and 75 percent day of year, in days
  }
}
\description{
This function calculates center of volume metrics, including the day of the 
hydrologic year that 25 percent, 50 percent, and 75 percent of the total annual 
streamflow is reached. A value of 0 is returned for years with no flow. Hydrologic 
years with fewer than normal observations (outliers) are excluded from the 
analysis, and for stations with seasonal flow records, additional seasonal 
subsetting is done to include only days with observations in all years.
}
\examples{
data(cania.sub.ts)
cania.sub.ts <- set.plot.titles(cania.sub.ts, 
title.elements = c("StationID", "StnName", "StateProv"))
res1 <- pk.cov(cania.sub.ts)

# trend and changepoint plot for baseflow peak start doy
res2 <- screen.metric(res1[,2], "Day of Year")
res2 <- screen.metric(res1[,2], "Day of Year", title = TRUE)
}
\author{
Jennifer Dierauer
}
