% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf.seas.R
\name{bf.seas}
\alias{bf.seas}
\title{Seasonal baseflow percentage}
\usage{
bf.seas(TS, seas = c(6:8))
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{seas}{Integers representing months of the year. Default is c(6:8), i.e. June-August.}
}
\value{
Returns a vector containing the calculated percentage for each year
  in the input time series.  The "times" attribute provides the corresponding
  year for each calculated value.
}
\description{
This function estimates the percentage of baseflow in a given period relative to the total
annual baseflow.
}
\details{
This function calls \code{\link{bf_eckhardt}} to complete the 
  baseflow separation.
}
\examples{
data(cania.sub.ts)
res <- bf.seas(cania.sub.ts)
res2 <- screen.metric(res, "Percent Annual Baseflow in Jun-Aug")
}
\seealso{
See \code{\link{bf.stats}} to calculate additional baseflow metrics.
}
\author{
Jennifer Dierauer
}
