% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexreg.R
\name{flexreg}
\alias{flexreg}
\title{Flexible Regression Models for Proportions}
\usage{
flexreg(
  formula,
  data,
  type = "FB",
  link.mu = "logit",
  prior.beta = "normal",
  hyperparam.beta = 100,
  link.phi = NULL,
  prior.phi = NULL,
  hyperparam.phi = NULL,
  prior.psi = NULL,
  hyperparam.psi = NULL,
  n.iter = 5000,
  burnin.perc = 0.5,
  n.chain = 1,
  thin = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{`formula`}: a symbolic description of the model to be fitted (of type \code{y ~ x} or \code{y ~ x | z}).}

\item{data}{an optional data frame, list, or object that is coercible to a data frame through \code{base::as.data.frame} containing the variables in the model. If not found in data, the variables in formula are taken from the environment from which the function flexreg is called.}

\item{type}{a character specifying the type of regression model. Current options are the flexible beta regression model \code{"FB"} (default), the variance inflated beta \code{"VIB"}, and the beta one \code{"Beta"}.}

\item{link.mu}{a character specifying the link function for the mean model (mu). Currently, \code{"logit"} (default), \code{"probit"}, \code{"cloglog"}, and \code{"loglog"} are supported.}

\item{prior.beta}{a character specifying the prior distribution for the \code{beta} regression coefficients of the mean model. Currently, \code{"normal"} (default) and \code{"cauchy"} are supported.}

\item{hyperparam.beta}{a positive numeric (vector of length 1) specifying the hyperprior standard deviation parameter for the prior distribution of \code{beta} regression coefficients. A value of 100 is suggested if the prior is \code{"normal"}, 2.5 if \code{"cauchy"}.}

\item{link.phi}{a character specifying the link function for the precision model (phi). Currently, \code{"identity"} (default), \code{"log"} and \code{"sqrt"} are supported.}

\item{prior.phi}{a character specifying the prior distribution for precision parameter \code{phi} if \code{link.phi = "identity"}. Currently, \code{"gamma"} (default) and \code{"unif"} are supported.}

\item{hyperparam.phi}{a positive numeric (vector of length 1) specifying the hyperprior parameter for the prior distribution of \code{phi}. If the prior is \code{"gamma"}, the value identifies the shape and rate parameters (a value of 0.001 is suggested). If the prior is \code{"uniform"} the hyperparameter must be specified to define the upper limit of the support of \code{phi}.}

\item{prior.psi}{a character specifying the prior distribution for \code{psi} regression coefficients of the precision model (not supported if link.phi is \code{"identity"}). Currently, \code{"normal"} (default) and \code{"cauchy"} are supported.}

\item{hyperparam.psi}{a positive numeric (vector of length 1) specifying the hyperprior standaerd deviation parameter for the prior distribution of \code{psi} regression coefficients. A value of 100 is suggested if the prior is \code{"normal"}, 2.5 if \code{"cauchy"}.}

\item{n.iter}{a positive integer specifying the number of iterations for each chain (including warmup). The default is 5000.}

\item{burnin.perc}{the percentage of iterations per chain to discard.}

\item{n.chain}{a positive integer specifying the number of Markov chains. The default is 1.}

\item{thin}{a positive integer specifying the period for saving samples. The default is 1.}

\item{verbose}{\code{TRUE} (default) or \code{FALSE}: flag indicating whether to print intermediate output.}

\item{...}{additional arguments for \code{rstan::sampling}.}
}
\value{
The \code{flexreg} function returns an object of class \code{`flexreg`}, i.e. a list with the following elements:
\item{\code{call}}{the function call.}
\item{\code{formula}}{the original formula.}
\item{\code{link.mu}}{a character specifing the link function in the mean model.}
\item{\code{link.phi}}{a character specifing the link function in the precision model.}
\item{\code{model}}{an object of class \code{`stanfit`} containing the fitted model.}
\item{\code{response}}{the response variable, assuming values in (0, 1).}
\item{\code{design.X}}{the design matrix for the mean model.}
\item{\code{design.Z}}{the design matrix for the precision model (if defined).}
}
\description{
The function fits some flexible regression models for continuous bounded responses (e.g., proportions and rates) via a Bayesian approach to inference based on Hamiltonian Monte Carlo algorithm.
Available regression models are the flexible beta regression model (\code{type="FB"}, default), the variance inflated beta (\code{type="VIB"}), and the beta one (\code{type="Beta"}).
}
\details{
Let \eqn{\mu} be the mean of a random variable Y whose distribution can be specified in the \code{type} argument.
Then the \code{flexreg} function links the parameter \eqn{\mu} to a linear predictor through a function  \eqn{g(\cdot)} specified in \code{link.mu}:
\deqn{g(\mu_i) = x_i^t \bold{\beta},} where \eqn{\bold{\beta}} is the vector of regression coefficients for the mean model.
By default, the precision parameter \eqn{\phi} is assumed to be constant.
It is possible to extend the model by linking \eqn{\phi} to an additional (possibly overlapping) set of covariates through a proper link
function \eqn{q(\cdot)}  specified in the \code{link.phi} argument: \deqn{q(\phi_i) = z_i^t \bold{\psi},} where \eqn{\bold{\psi}} is the vector of regression coefficients for the precision model.
In \code{flexreg}, the regression model for the mean and, where appropriate, for the precision parameter can be specified in the
\code{formula} argument with a formula of type \eqn{y \sim x_1 + x_2 | z_1 + z_2} where covariates on the left of ("|") are included in the regression model
for the mean and covariates on the right of ("|") are included in the regression model for the precision.

If the second part is omitted, i.e., \eqn{y \sim x_1 + x_2}, the precision is assumed constant for each observation.
}
\examples{
\dontrun{
data("Reading")
FB <- flexreg(accuracy ~ iq, Reading, type="FB", n.iter=1000)
}
}
\references{
{
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018) A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079 \cr
\cr
Di Brisco, A. M., Migliorati, S., Ongaro, A. (2020) Robustness against outliers: A new variance inflated regression model for proportions. Statistical Modelling, \bold{20}(3), 274--309. doi:10.1177/1471082X18821213 \cr
\cr
 Ferrari, S.L.P., and Cribari-Neto, F. (2004). Beta Regression for Modeling Rates and Proportions. Journal of Applied Statistics, \bold{31}(7), 799--815. doi:10.1080/0266476042000214501
}
}
