% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATA.R
\name{Consumption}
\alias{Consumption}
\title{Italian Households Consumption data}
\format{
A data frame containing 568 observations on the following 8 variables.
\describe{
\item{\code{NComp}}{the number of household members.}
\item{\code{Sex}}{the sex of the head of household.}
\item{\code{Age}}{the age of the head of household.}
\item{\code{NEarners}}{the number of household income earners.}
\item{\code{Area}}{a factor indicating the geographical area where the household is located.}
\item{\code{Citizenship}}{a factor indicating the citizenship of the head of household.}
\item{\code{Income}}{the net disposable income.}
\item{\code{Consumption}}{the propensity to consume, defined as the percentage of \code{Income} that is spent rather than saved.}
}
}
\source{
{  \href{https://www.bancaditalia.it/statistiche/tematiche/indagini-famiglie-imprese/bilanci-famiglie/distribuzione-microdati/index.html?com.dotmarketing.htmlpage.language=1}{Bank of Italy, Survey on Household Income and Wealth, 2016}. \cr
\cr
\href{https://www.bancaditalia.it/statistiche/tematiche/indagini-famiglie-imprese/bilanci-famiglie/documentazione/documenti/2016/eng_Legen16.pdf?language_id=1}{Survey description.}
}
}
\description{
This dataset is a subset from the 2016 Survey on Household Income and Wealth data, a statistical survey conducted by Bank of Italy. The statistical units are the households and the head of the household is conventionally selected as the major income earner.
}
\details{
Full data are available on the website of the Bank of Italy. \code{Consumption} has been created by dividing the variable `consumption` over the `net disposable income`.
}
