% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDistUlt.R
\name{FDistUlt}
\alias{FDistUlt}
\title{Fit to a mixed univariate distributions}
\usage{
FDistUlt(X, n.obs = length(X), ref = "OP", crt = 1, plot = FALSE,
  subplot = FALSE, p.val_min = 0.05)
}
\arguments{
\item{X}{A random sample to be fitted.}

\item{n.obs}{A positive integer, is the length of the random sample to be generated}

\item{ref}{Aumber of clusters to use by the kmeans function to split the distribution, if isn't a number, uses mclust classification by default.}

\item{crt}{Criteria to be given to FDist() function}

\item{plot}{FALSE. If TRUE, generates a plot of the density function.}

\item{subplot}{FALSE. If TRUE, generates the plot of the mixed density function's partitions.}

\item{p.val_min}{Minimum p.value to be given to non-reject the null hypothesis.}
}
\value{
A list with whe density functions, a random sample, a  data frame with p.values results, the corresponding plots an the random numbers generator functions
}
\description{
Fit to a mixed univariate distributions
}
\examples{
X<-c(rnorm(73,189,12),rweibull(82,401,87),rgamma(90,40,19))
A_X<-FDistUlt(X,plot=TRUE,subplot=TRUE)
#A_X[[1]][[1]]()
#A_X[[2]]
#A_X[[3]]
#x11();A_X[[4]][[1]]
#x11();A_X[[4]][[2]]
#A_X[[5]][[1]]()


}
