% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAYMET_FUNCTIONS.R
\name{download_daymet_tile}
\alias{download_daymet_tile}
\title{Download a netcdf tile from the 1-km DAYMET daily weather dataset.}
\usage{
download_daymet_tile(tileID, elements, years, raw.dir)
}
\arguments{
\item{tileID}{A numeric indicating the DAYMET tile ID number.}

\item{elements}{A character vector of elemets to extract.\cr
The available elements are:\cr
dayl = Duration of the daylight period in seconds per day. This calculation is based on the period of the day during which the sun is above a hypothetical flat horizon.\cr
prcp = Daily total precipitation in millimeters per day, sum of all forms converted to water-equivalent. Precipitation occurrence on any given day may be ascertained.\cr
srad = Incident shortwave radiation flux density in watts per square meter, taken as an average over the daylight period of the day. NOTE: Daily total radiation (MJ/m2/day) can be calculated as follows: ((srad (W/m2) * dayl (s/day)) / l,000,000)\cr
swe = Snow water equivalent in kilograms per square meter. The amount of water contained within the snowpack.\cr
tmax = Daily maximum 2-meter air temperature in degrees Celsius.\cr
tmin = Daily minimum 2-meter air temperature in degrees Celsius.\cr
vp = Water vapor pressure in pascals. Daily average partial pressure of water vapor.\cr}

\item{years}{A numeric vector of years to extract.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/DAYMET/".}
}
\value{
A named list of character vectors, each representing the full local paths of the tile downloads.
}
\description{
Tiles are specified by a tile ID, year, and element;
Tiles are downloaded in the NetCDF format. \code{download_daymet_tile} returns the path to the downloaded NetCDF tile files.
}
\keyword{internal}

