% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{filterset}
\alias{filterset}
\title{Function for filtering expression data}
\usage{
filterset(x, n = NULL, minexpr = 2, minnumber = 1)
}
\arguments{
\item{x}{expression data frame with genes as rows and cells as columns. Gene IDs should be given as row names and cell IDs should be given as column names.}

\item{n}{ordered vector of cell IDs to be included. Cell IDs need to be column names of \code{x}. If not provided, then all cell IDs are included in arbitray order. Default value is \code{NULL}.}

\item{minexpr}{positive real number. This is the minimum expression required for at least \code{minnumber} cells. All genes that do not fulfill this criterion are removed. The default value is 2.}

\item{minnumber}{positive integer number. This is the minimum number of cells in which a gene needs to be expressed at least at a level of \code{minexpr}. All genes that do not fulfill this criterion are removed. The default value is 1.}
}
\value{
Reduced expression data frame with genes as rows and cells as columns in the same order as in \code{n}.
}
\description{
This function discards lowly expressed genes from the expression data frame.
}
