% Generated by roxygen2 (4.0.1): do not edit by hand
\name{estimkiener11}
\alias{estimdelta11}
\alias{estimgamma11}
\alias{estimkappa11}
\alias{estimkiener11}
\alias{estimkiener5}
\alias{estimkiener7}
\title{Parameter Estimation of Kiener Distributions From 5, 7 or 11 Quantiles}
\usage{
estimkiener11(x11, p11, ord = 7, maxk = 10)

estimkiener7(x7, p7, maxk = 10)

estimkiener5(x5, p5, maxk = 10)

estimdelta11(x11, p11, ord)

estimkappa11(x11, p11, ord, maxk = 10)

estimgamma11(x11, p11, k, ord)
}
\arguments{
\item{x5,x7,x11}{vector of 5, 7 or 11 quantiles.}

\item{p5,p7,p11}{vector of 5, 7 or 11 probabilities.}

\item{ord}{integer. Option for quantile selection and treatment.}

\item{k}{numeric. parameter k used in model k3 and k4.}

\item{maxk}{numeric. Maximum allowed value for k (kappa).}
}
\description{
Parameter estimation of Kiener Distributions with just 5, 7 or 11 quantiles.










}
\details{
These functions are called by \code{\link{estimkienerX}} to estimate
the parameters of a Kiener distribution applied to a dataset \code{X}.
\code{p11, x11} are obtained with the functions \code{elevenprobs(X)} and \code{quantile(p11)}.
\code{p7, x7} are obtained with the functions \code{sevenprobs(X)} and \code{quantile(p7)}.
\code{p5, x5} are obtained with the functions \code{fiveprobs(X)} and \code{quantile(p5)}.
\code{k} is parameter k (kappa) of Kiener distributions.

The treatment of the 11 quantiles is controlled with the option \code{ord}
which can take 12 integer values, \code{ord = 7} being the default:
\itemize{
  \item{ 1: c(1-p1, 0.35, 0.50, 0.65, p1)}
  \item{ 2: c(1-p2, 0.35, 0.50, 0.65, p2)}
  \item{ 3: c(1-p1, 1-p2, 0.35, 0.50, 0.65, p2, p1)}
  \item{ 4: c(1-p1, 1-p2, 1-p3, 0.35, 0.50, 0.65, p3, p2, p1)}
  \item{ 5: c(1-p1, 0.25, 0.50, 0.75, p1)}
  \item{ 6: c(1-p2, 0.25, 0.50, 0.75, p2)}
  \item{ 7: c(1-p1, 1-p2, 0.25, 0.50, 0.75, p2, p1)}
  \item{ 8: c(1-p1, 1-p2, 1-p3, 0.25, 0.50, 0.75, p3, p2, p1)}
  \item{ 9: c(1-p1, 0.25, 0.35, 0.50, 0.65, 0.75, p1)}
  \item{10: c(1-p2, 0.25, 0.35, 0.50, 0.65, 0.75, p2)}
  \item{11: c(1-p1, 1-p2, 0.25, 0.35, 0.50, 0.65, 0.75, p2, p1)}
  \item{12: c(1-p1, 1-p2, 1-p3, 0.25, 0.35, 0.50, 0.65, 0.75, p3, p2, p1)}
}

The treatment of the 7 quantiles has only one solution:
\itemize{
  \item{ 1: c(1-p1, 1-p2, 0.25, 0.50, 0.75, p2, p1)}
}

The treatment of the 5 quantiles has only one solution:
\itemize{
  \item{ 1: c(1-p1, 0.25, 0.50, 0.75, p1)}
}

Parameter maxk controls the maximum allowed value for estimated parameter k.
Reasonnable values are \code{maxk = 10, 15, 20}. Default is \code{maxk = 10}
to be consistent with \code{\link{regkienerLX}}.
}
\examples{
require(timeSeries)

## Choose j in 1:16. Choose ord in 1:12 (5 is default)
DS   <- getDSdata()
j    <- 5
ord  <- 5
p11  <- elevenprobs(DS[[j]])
x11  <- quantile(DS[[j]], probs = p11, na.rm = TRUE, names = TRUE, type = 6)
estimkiener11(x11, p11, ord)
## end
}
\seealso{
\code{\link{elevenprobs}}, \code{\link{estimkienerX}},
\code{\link[stats]{quantile}},
\code{\link{qkiener2}}, \code{\link{qkiener3}}, \code{\link{qkiener4}}.
}

