% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUCjmcs.R
\name{AUCjmcs}
\alias{AUCjmcs}
\title{Time-dependent AUC/Cindex for joint models}
\usage{
AUCjmcs(
  seed = 100,
  object,
  landmark.time = NULL,
  horizon.time = NULL,
  obs.time = NULL,
  method = c("Laplace", "GH"),
  quadpoint = NULL,
  maxiter = NULL,
  n.cv = 3,
  survinitial = TRUE,
  initial.para = FALSE,
  LOCF = FALSE,
  LOCFcovariate = NULL,
  clongdata = NULL,
  metric = c("AUC", "Cindex"),
  ...
)
}
\arguments{
\item{seed}{a numeric value of seed to be specified for cross validation.}

\item{object}{object of class 'jmcs'.}

\item{landmark.time}{a numeric value of time for which dynamic prediction starts..}

\item{horizon.time}{a numeric vector of future times for which predicted probabilities are to be computed.}

\item{obs.time}{a character string of specifying a longitudinal time variable.}

\item{method}{estimation method for predicted probabilities. If \code{Laplace}, then the empirical empirical
estimates of random effects is used. If \code{GH}, then the pseudo-adaptive Gauss-Hermite quadrature is used.}

\item{quadpoint}{the number of pseudo-adaptive Gauss-Hermite quadrature points if \code{method = "GH"}.}

\item{maxiter}{the maximum number of iterations of the EM algorithm that the 
function will perform. Default is 10000.}

\item{n.cv}{number of folds for cross validation. Default is 3.}

\item{survinitial}{Fit a Cox model to obtain initial values of the parameter estimates. Default is TRUE.}

\item{initial.para}{Initial guess of parameters for cross validation. Default is FALSE.}

\item{LOCF}{a logical value to indicate whether the last-observation-carried-forward approach applies to prediction. 
If \code{TRUE}, then \code{LOCFcovariate} and \code{clongdata} must be specified to indicate 
which time-dependent survival covariates are included for dynamic prediction. Default is FALSE.}

\item{LOCFcovariate}{a vector of string with time-dependent survival covariates if \code{LOCF = TRUE}. Default is NULL.}

\item{clongdata}{a long format data frame where time-dependent survival covariates are incorporated. Default is NULL.}

\item{metric}{a string to indicate which metric is used.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
a list of matrices with conditional probabilities for subjects.
}
\description{
Time-dependent AUC/Cindex for joint models
}
\seealso{
\code{\link{jmcs}, \link{survfitjmcs}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
