% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{farm.test}
\alias{farm.test}
\title{Main function performing factor-adjusted robust test for means}
\usage{
farm.test(X, H0 = NULL, fx = NULL, Kx = NULL, Y = NULL, fy = NULL,
  Ky = NULL, alternative = c("two.sided", "less", "greater"),
  alpha = NULL, verbose = TRUE, ...)
}
\arguments{
\item{X}{a n x p data matrix with each row being a sample.
You wish to test a hypothesis for the mean of each column of \code{X}.}

\item{H0}{an \emph{optional} p x 1 vector of the true value of the means (or difference in means if you are performing a two sample test). The default is the zero.}

\item{fx}{an \emph{optional} factor matrix with each column being a factor for \code{X}. Same number of rows as \code{X}.}

\item{Kx}{a \emph{optional} number of factors to be estimated for \code{X}. Otherwise estimated internally.}

\item{Y}{an \emph{optional} data matrix that must have the same number of columns as \code{X}. You wish test the equality of means of each columns of \code{X} and \code{Y}.}

\item{fy}{an \emph{optional} factor matrix with each column being a factor for \code{Y}.  Same number of rows as \code{Y}. Only used for a two sample test.}

\item{Ky}{a \emph{optional} number of factors to be estimated for \code{Y}. Otherwise estimated internally.}

\item{alternative}{an \emph{optional} character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{alpha}{an \emph{optional} level for controlling the false discovery rate (in decimals). Default is 0.05. Must be in \eqn{(0,1)}.}

\item{verbose}{a logical indicating whether to print summary of the run to console. Default is TRUE.}

\item{\dots}{Arguments passed to the \code{\link{farm.FDR}} function.}
}
\value{
A list with the following items
\item{means}{the vector of estimated means}
\item{stderr}{the p x 1 vector of estimated standard errors}
\item{pvalue}{the p x 1 vector of unadjusted p values}
\item{rejected}{the indices of rejected hypotheses, along with their corresponding p values, and adjusted p values, ordered from most significant to least significant}
\item{alldata}{all the indices of the tested hypotheses, along with their corresponding p values, adjusted p values, and a column with 1 if declared siginificant and 0 if not}
\item{loadings}{estimated factor loadings}
\item{nfactors}{if needed, the number of estimated factors}
}
\description{
This function is used to conduct robust statistical test for means of multivariate data, after adjusting for known or unknown latent factors.
It uses the Huber's loss function (Huber (1964)) to robustly estimate data parameters.
}
\details{
\code{alternative = "greater"} is the alternative that \code{X} has a larger mean than \code{Y}.

If some of the underlying factors are known but it is suspected that there are more confounding factors that are unobserved: Suppose we have data \eqn{X = \mu + Bf + Cg + u}, where \eqn{f} is observed and \eqn{g} is unobserved. In the first step, the user passes the data \eqn{\{X,f\}} into the main function. From the output, let us construct the residuals: \eqn{Xres = X - Bf}. Now pass \eqn{Xres} into the main function, without any factors. The output in this step is the final answer to the testing problem.

Number of rows and columns of the data matrix must be at least 4 in order to be able to calculate latent factors.

For details about multiple comparison correction, see \code{\link{farm.FDR}}.
}
\examples{
set.seed(100)
p = 20
n = 10
epsilon = matrix(rnorm( p*n, 0,1), nrow = n)
B = matrix(rnorm(p,0,1), nrow=p)
fx = matrix(rnorm(n, 0,1), nrow = n)
mu = rep(0, p)
mu[1:5] = 2
X = rep(1,n)\%*\%t(mu)+fx\%*\%t(B)+ epsilon
output1 = farm.test(X)
output = farm.test(X, alpha = 0.01,alternative = "greater")

}
\references{
Huber, P.J. (1964). "Robust Estimation of a Location Parameter." The Annals of Mathematical Statistics, 35, 73–101.
}
