% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequentialSelection.R
\name{sequentialFloatingBackwardSelection}
\alias{sequentialFloatingBackwardSelection}
\title{Sequential Floating Backward Selection}
\usage{
sequentialFloatingBackwardSelection()
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on sequential floating backward selection. This function is called internally within the \code{\link{searchAlgorithm}} function. The sfbs method \insertCite{Pudil1994}{FSinR} starts with all the features and removes a single feature at each step with a view to improving the evaluation of the set. In addition, it checks whether adding any of the removed features, improve the value of the set.
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the search function with sfbs
sfbs_search <- sequentialFloatingBackwardSelection()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
sfbs_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
