% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_freg.R
\name{plot_freg}
\alias{plot_freg}
\title{Plot coefficients from FREG model}
\usage{
plot_freg(object)
}
\arguments{
\item{object}{FREG model}
}
\value{
plot of the beta coefficient regression functions for each variable
}
\description{
Plot coefficients from FREG model
}
\examples{
\donttest{
library(fda)
y = log10(apply(CanadianWeather$dailyAv[1:335,,2],2,sum))
x = CanadianWeather$dailyAv[1:335,,1] # temperature
xbasis = create.fourier.basis(c(1,335),5)
xfd = smooth.basis(c(1:335),x,xbasis)$fd
bbasis = create.fourier.basis(c(1,335),5)
betalist = list(bbasis)
formula = y ~ xfd
freg.model = freg(formula = formula, betalist = betalist)
plot_freg(freg.model)
}

}
