% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{optimization}
\alias{optimization}
\title{Fisher Scoring algorithm}
\usage{
optimization(x, y, beta, loglik, gradient, Hessian)
}
\arguments{
\item{x}{a design matrix which is a product of inner product of basis functions and basis coefficients of functional covariate \code{X}}

\item{y}{a response variable of class \code{factor}}

\item{beta}{initial values for beta regression coefficients and intercepts}

\item{loglik}{log-likelihood function}

\item{gradient}{function for the estimation of first derivative of log-likelihood function - gradient}

\item{Hessian}{function for the estimation of second derivative of log-likelihood function - Hessian}
}
\value{
\item{beta}{  a vector with estimated beta regression coefficients and intercepts}

\item{ll}{  a value of the log-likelihood function at the estimated optimum}

\item{grd}{  a vector of gradient values at the estimated optimum}

\item{hessian}{  Hessian matrix at the estimated optimum}
}
\description{
Optimization algorithm for the estimation of beta regression coefficient functions and intercepts
}
