% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{classtable}
\alias{classtable}
\title{Compute classification statistics for binary prediction and criterion (e.g.; truth) vectors}
\usage{
classtable(
  prediction_v = NULL,
  criterion_v,
  sens.w = 0.5,
  cost.v = NULL,
  correction = 0.25,
  cost.outcomes = list(hi = 0, fa = 1, mi = 1, cr = 0),
  na_prediction_action = "ignore"
)
}
\arguments{
\item{prediction_v}{logical. A logical vector of predictions.}

\item{criterion_v}{logical. A logical vector of (TRUE) criterion values.}

\item{sens.w}{numeric. Sensitivity weight parameter (from 0 to 1, for computing \code{wacc}).
Default: \code{sens.w = .50}.}

\item{cost.v}{list. An optional list of additional costs to be added to each case.}

\item{correction}{numeric. Correction added to all counts for calculating dprime.}

\item{cost.outcomes}{list. A list of length 4 with names 'hi', 'fa', 'mi', and 'cr' specifying
the costs of a hit, false alarm, miss, and correct rejection, respectively.
For instance, \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that
a false alarm and miss cost 10 and 20, respectively, while correct decisions have no cost.}

\item{na_prediction_action}{not sure.}
}
\description{
The primary confusion matrix is computed by \code{\link{confusionMatrix}} of the \strong{caret} package.
}
