% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictFFTrees_function.R
\name{predict.FFTrees}
\alias{predict.FFTrees}
\title{Applies an existing FFTrees object to a new dataset}
\usage{
\method{predict}{FFTrees}(object = NULL, data = NULL, formula = NULL,
  tree = NULL, level.name.v = NULL, level.threshold.v = NULL,
  level.sigdirection.v = NULL, level.exit.v = NULL, level.class.v = NULL,
  ...)
}
\arguments{
\item{object}{(M) An FFTrees object created from the FFTrees() function.}

\item{data}{(M) An m x n dataframe containing n cue values for each of the m exemplars.}

\item{formula}{a formula}

\item{tree}{An integer indicating which tree to plot (only valid when the tree argument is non-empty). To plot the best training (or test) tree with respect to v (HR - FAR), use "best.train" or "best.test"}

\item{level.name.v}{A character indicating the names of the levels in the tree separated by ;. For example "age;sex;occupation"}

\item{level.threshold.v}{(M) A character indicating the level thresholds separated by ;. For example "25;female;occupation"}

\item{level.sigdirection.v}{(M) A character vector of length n indicating the direction for which exemplars are classified as signals for each cue. Values must be in the set "<" (strictly less than), "<=" (less than or equal to), "=" (equal), "!=" (unequal), ">=" (greater than or equal to), or ">" (strictly greater than)/}

\item{level.exit.v}{(B) A numeric vector of length n indicating the exit direction for each level. 0 = noise clasification, 1 = signal decision, .5 = both.}

\item{level.class.v}{(B) A character vector of length n indicating the class of the cues for each level. "F" = factor, "N" = numeric, "L" = logical.}

\item{...}{Additional arguments passed on to predict()}
}
\value{
A list of length 3. The first element "decision.df" is a dataframe with the decisions (and level of decisions) for each exemplar. The second element, "final.df" is a dataframe showing final tree accuracy statistics. The third element "level.df" shows tree accuracy statistics at each level.
}
\description{
Applies an existing FFTrees object to a new dataset
}

