% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{plot.femlm.allClusters}
\alias{plot.femlm.allClusters}
\title{Displaying the most notable fixed-effects}
\usage{
\method{plot}{femlm.allClusters}(x, n = 5, ...)
}
\arguments{
\item{x}{An object obtained from the function \code{\link{getFE}}.}

\item{n}{The number of fixed-effects to be drawn. Defaults to 5.}

\item{...}{Not currently used.

Note that the fixed-effect coefficients might NOT be interpretable. This function is useful only for fully regular panels.

If the data are not regular in the cluster coefficients, this means that several \sQuote{reference points} are set to obtain the fixed-effects, thereby impeding their interpretation. In this case a warning is raised.}
}
\description{
This function plots the 5 fixed-effects with the highest and lowest values, for each of the clusters. It takes as an argument the fixed-effects obtained from the function \code{\link{getFE}} after and estimation using \code{\link{femlm}}.
}
\examples{

data(trade)

# We estimate the effect of distance on trade
# => we account for 3 cluster effects
est_pois = femlm(Euros ~ log(dist_km)|Origin+Destination+Product, trade)

# obtaining the cluster coefficients
fe_trade = getFE(est_pois)

# plotting them
plot(fe_trade)

# plotting only the Products fixed-effects & showing more of them
plot(fe_trade$Product, n=8)


}
\seealso{
\code{\link[FENmlm]{getFE}} to extract clouster coefficients. See also the main estimation function \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{summary.femlm}} to see the results with the appropriate standard-errors, the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
