% Generated by roxygen2 (4.0.0): do not edit by hand
\name{Laplace}
\alias{Laplace}
\alias{dLaplace}
\alias{eLaplace}
\alias{iLaplace}
\alias{lLaplace}
\alias{pLaplace}
\alias{qLaplace}
\alias{rLaplace}
\alias{sLaplace}
\title{The Laplace Distribution.}
\usage{
dLaplace(x, mu = 0, b = 1, params = list(mu, b))

pLaplace(q, mu = 0, b = 1, params = list(mu, b))

qLaplace(p, mu = 0, b = 1, params = list(mu, b))

rLaplace(n, mu = 0, b = 1, params = list(mu, b))

eLaplace(X, w, method = "numerical.MLE")

lLaplace(x, w = 1, mu = 0, b = 1, params = list(mu, b), logL = TRUE)
}
\arguments{
\item{params}{a list that includes all named parameters}

\item{x,q}{vector of quantiles.}

\item{w}{weights of sample.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{mu}{location parameter.}

\item{b}{scale parameter.}

\item{method}{parameter estimation method.}

\item{logL}{logical, it is assumed that the log likelihood is desired. Set to FALSE if the
likelihood is wanted.}

\item{...}{other parameters}
}
\value{
dLaplace gives the density; pLaplace gives the distribution function, qLaplace gives the
quantile function, rLaplace generates random variables and eLaplace estimates the parameters.
lLaplace will provide the log-likelihood.
}
\description{
Density (d), distribution (p), and quantile (q), random number generation (r),
and parameter estimation (e) functions for the Laplace distribution. Parameter estimation can
only be based on an unweighted i.i.d. sample.
}
\details{
Laplace Distribution

no details yet.
}
\note{
The estimation of the population mean is done using the median of the sample. Unweighted
samples are not yet catered for in the eLaplace() function.
}
\examples{
\donttest{
# Parameter estimation
n <- 500
mu <- 1
b <- 2
X <- rLaplace(n, mu, b)
(est.par <- eLaplace(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dLaplace(den.x,mu=est.par$mu,b=est.par$b)
hist(X, breaks=10, col="red", probability=TRUE, ylim=c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qLaplace((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim=c(-5,5), ylim=c(-5,5))
abline(0,1)

plot((1:n-0.5)/n, pLaplace(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim=c(0,1), ylim=c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(mu=1, b=2)
X <- rLaplace(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eLaplace(X,w) # estimated parameters of weighted sample
eLaplace(X) # estimated parameters of unweighted sample

# Alternative parameter estimation methods
eLaplace(X, method="numerical.MLE")

# Extracting location or scale parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rLaplace,edist=eLaplace,n=1000, rep.num=1e3, params=list(mu=1, b=2))
eval.estimation(rdist=rLaplace,edist=eLaplace,n=1000, rep.num=1e3, params=list(mu=1, b=2),
method ="analytical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rLaplace(1000, mu, b)
(est.par <- eLaplace(X))
H <- attributes(eLaplace(X, method="numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lLaplace(X,param=est.par)
lLaplace(X,param=est.par, logL=FALSE)
}
}
\author{
A. Jonathan R. Godfrey and Haizhen Wu
}

