% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expos.R
\name{expos_model}
\alias{expos_model}
\alias{expos_damage}
\title{Modeling Functions}
\usage{
expos_model(
  wind_direction,
  inflection_angle,
  lat_long = NULL,
  orient = 0,
  save = TRUE,
  exp_path = NULL
)

expos_damage(
  hurricane,
  inflection_angle,
  protect,
  save = TRUE,
  exp_path = NULL
)
}
\arguments{
\item{wind_direction}{wind direction (degrees)}

\item{inflection_angle}{inflection angle (degrees)}

\item{lat_long}{whether coordinate system is latitude/longitude}

\item{orient}{map orientation (degrees)}

\item{save}{whether to save results to file}

\item{exp_path}{path for current set of model runs}

\item{hurricane}{hurricane name (as it appears in tif file)}

\item{protect}{how much to reduce damage in protected areas (number of 
Fujita scale ratings)}
}
\value{
raster of modeled exposure values

raster of modeled wind damage values
}
\description{
expos_model uses a raster file of elevation values, a specified wind
direction, and a specified inflection angle to create a raster file
of wind exposure values (0 = missing data, 1 = protected, 2 = exposed).
The user can specify if coordinates are lat/long; otherwise lat/long 
is assumed if X values are between -180 and 180 and Y values are between
-90 and 90. If lat/long, horizontal and vertical units are assumed 
to be degrees and meters, respectively; otherwise horizontal and vertical 
units must be the same. Columns are assumed to be closely aligned with 
true North (0 degrees); if not, the map orientation (azimuth) must be 
specified in degrees. The name of the input file is assumed to be "dem.tif".

expos_damage uses output from the EXPOS and HURRECON models to create 
a raster of hurricane wind damage where topographic exposure at each 
location is determined by peak wind direction. If a location is protected, 
the enhanced Fujita scale rating from HURRECON is reduced by a specified 
amount. This function requires a hurricane file in GeoTiff format created 
by HURRECON, exposure files created by EXPOS for the eight cardinal wind 
directions (N, NE, E, etc), and a reprojection file in CSV format 
(reproject.csv) that contains lat/long coordinates in degrees for the 
lower left and upper right corners of the digital elevation model.
}
\examples{
exp_path <- system.file("", package="ExposR", mustWork=TRUE)
expos_model(wind_direction=135, inflection_angle=6, save=FALSE, exp_path=exp_path)
}
