% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Ticker_infos.R
\name{EN_Ticker_infos}
\alias{EN_Ticker_infos}
\title{Get Ticker Information}
\usage{
EN_Ticker_infos(ticker, escape = FALSE, stock_type = "Eq_Ind")
}
\arguments{
\item{ticker}{A character string representing the company's ticker, name, or ISIN.}

\item{escape}{Boolean, either TRUE or FALSE. If escape is True, it means you're providing the DNA (ISIN-Market identifier) directly. Giving T to escape is helpful to avoid time-consuming operations; otherwise, F means you need to provide the Ticker symbol, name, or ISIN and the type of market to which it belongs.}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes, 'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers, and 'Etfs' or "E" for EFTs.}
}
\value{
A data frame containing detailed information for the specified stock ticker.
If the specified ticker is not found, the function returns an error message.
}
\description{
This function retrieves detailed information for a given stock ticker on the Euronext exchange.
It includes information such as currency, last traded price, valuation close, volume, turnover,
transactions, VWAP (Volume Weighted Average Price), open, high, low, threshold, previous close,
52-week range, and market capitalization.
The data is returned as a data frame.
}
\examples{

library(httr)
library(jsonlite)
library(rvest)
library(stringr)
library(rlang)
library(magrittr)

#Get ABCA informations
dt_ABCA = EN_Ticker_infos("ABca")
print(dt_ABCA)

dt_EOS = EN_Ticker_infos("EOS")
print(dt_EOS)


dt_fund = EN_Ticker_infos("CH1135202138-XPAR", stock_type = "F", escape = TRUE)
print(dt_fund)
\donttest{

dt_new = EN_Ticker_infos("AAPL", stock_type = "E") # To Get ETF AAPL informations
print(dt_new)

# To show only 5 pages of bonds list and select directly the bond DNA
dt_ = EN_Bonds_List()
# To Get informations about BOND issued in 2019 by POPOLARE BARI RMBS
dt_new1 = EN_Ticker_infos("IT0005386716-XMOT", stock_type = "B", escape = TRUE)
print(dt_new1)

dt_newfund = EN_Ticker_infos("KGHDF", stock_type = "F")
print(dt_newfund)

}

}
\seealso{
\code{\link{EN_GetISIN}} to retrieve the ISIN for a given ticker.

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\concept{Data Retrieval}
\concept{Euronext}
