% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Get_News.R
\name{EN_Get_News}
\alias{EN_Get_News}
\title{Get Ticker latest news (recent information)}
\usage{
EN_Get_News(ticker, escape = FALSE, stock_type = "Eq_Ind")
}
\arguments{
\item{ticker}{A character string representing the company's ticker, name, or ISIN.}

\item{escape}{Boolean, either TRUE or FALSE. If escape is True, it means you're providing the DNA
(ISIN-Market identifier) directly. Giving T to escape is helpful to avoid time-consuming
operations; otherwise, F means you need to provide the Ticker symbol, name, or ISIN
and the type of market to which it belongs.}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes, 'Fund' or "F" for Fund tickers,
'Bond' or "B" for Bond tickers, and 'Etfs' or "E" for EFTs.}
}
\value{
A data frame containing historical performance data of the specified company.
If the ticker is not found, it returns the message "Ticker not found."
}
\description{
This function retrieves the update information of a company listed on the Euronext exchange
based on its ticker symbol. It returns a table with details such as its real Name, ISIN,
Last traded Price, Date of last update, and other relevant informations.
}
\examples{
\donttest{
library(httr)
library(httr2)
library(rvest)
library(jsonlite)
library(stringr)
library(rlang)

# Equities ex "NL0000852564-XAMS"
# Stock AALBERTS N.V.
equity_new <- EN_Get_News("NL0000852564-XAMS", escape = TRUE)
print(equity_new)

#ABO GROUP ENVIRONMENT Stock
equity_new1 <- EN_Get_News("ABO")
print(equity_new1)

# Indexes
# AEX All-Share Index GR
index_new <- EN_Get_News("QS0011224977-XAMS", escape = TRUE)
print(index_new)
# AEX X12 Short GR Index
index_new1 <- EN_Get_News("AE12S")
print(index_new1)

# Fund
# Fund KEMPEN ORANGE FUND N.V.
fund_new <- EN_Get_News("KORAF", stock_type = "F")
print(fund_new)

# Fund of ASN DUURZAAM MIXFONDS ZEER DEFENSIEF
fund_new1 <- EN_Get_News("NL0014270274-XAMS", escape = TRUE, stock_type = "F")
print(fund_new1)

# Etfs cases
# 21Shares Stacks Staking ETP
etf_new <- EN_Get_News("CH1258969042-XAMS", escape = TRUE, stock_type = 'E')

# Leverage Shares 2x Long Berkshire Hathaway (BRK-B) ETP Securities
etf_new1 <- EN_Get_News("2BRK", stock_type = "E")

# Bond A2A 1.75\% CALL 25FB25
bd_new <- EN_Get_News("XS1195347478-ETLX", escape = TRUE)
print(bd_new)
# Bond AAB0.45\%12DEC2036
bd_new1 <- EN_Get_News("XS2093705064-XAMS", escape = TRUE)
print(bd_new1)
}

}
\seealso{
\code{\link{EN_GetISIN}} to get DNA of a giving Company or Index Ticker/Name/ISIN
(Fund, Bond, and ETF are excluded), \code{\link{EN_GetISIN_Etf}} to get the ISIN of
a giving ETFs DNA, \code{\link{EN_GetISIN_B}} to get a giving Bond DNA,
\code{\link{EN_GetISIN_F}} to get a giving Fund DNA.

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Indices_List}()},
\code{\link{EN_Stocks_List}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\concept{Euronext}
\concept{Infos Retrieval}
