% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EunomiaData.R
\name{extractLoadData}
\alias{extractLoadData}
\title{Extract the Eunomia data files and load into a database
Extract files from a .ZIP file and creates a OMOP CDM database that is then stored in the
same directory as the .ZIP file.}
\usage{
extractLoadData(
  from,
  to,
  dbms = "sqlite",
  cdmVersion = "5.3",
  inputFormat = "csv",
  verbose = FALSE
)
}
\arguments{
\item{from}{The path to the .ZIP file that contains the csv CDM source files}

\item{to}{The path to the .sqlite or .duckdb file that will be created}

\item{dbms}{The file based database system to use: 'sqlite' (default) or 'duckdb'}

\item{cdmVersion}{The version of the OMOP CDM that are represented in the archive files.}

\item{inputFormat}{The format of the files expected in the archive. (csv or parquet)}

\item{verbose}{Provide additional logging details during execution.}
}
\value{
No return value, called to load archive into a database file.
}
\description{
Extract the Eunomia data files and load into a database
Extract files from a .ZIP file and creates a OMOP CDM database that is then stored in the
same directory as the .ZIP file.
}
\examples{
\dontrun{
extractLoadData("c:/strategusData/GiBleed_5.3.zip")
}
}
\seealso{
\code{\link[Eunomia]{downloadEunomiaData}}
}
