% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ethseq_Analysis.R
\name{ethseq.Analysis}
\alias{ethseq.Analysis}
\title{Ethnicity analysis from whole-exome sequencing data}
\usage{
ethseq.Analysis(target.vcf = NA, target.gds = NA, bam.list = NA,
  out.dir = "/tmp", model.gds = NA, model.available = NA,
  model.folder = "/tmp", run.genotype = FALSE, aseq.path = "/tmp",
  mbq = 20, mrq = 20, mdc = 10, cores = 1, verbose = TRUE,
  composite.model.call.rate = 1, refinement.analysis = NA)
}
\arguments{
\item{target.vcf}{Path to the sample's genotypes in VCF format}

\item{target.gds}{Path to the sample's genotypes in GDS format}

\item{bam.list}{Path to a file containing a list of BAM files paths}

\item{out.dir}{Path to the folder where the output of the analysis is saved}

\item{model.gds}{Path to a GDS file specifying the reference model}

\item{model.available}{String specifying the pre-computed reference model to use (SS2, SS2.Light, SS4, NimblegenV3, HALO). Models with postfix .Light are built with less reference samples.}

\item{model.folder}{Path to the folder where reference models are already present or downloaded when needed}

\item{run.genotype}{Logical values indicating whether the ASEQ genotype should be run}

\item{aseq.path}{Path to the folder where ASEQ binary is available or is downloaded when needed}

\item{mbq}{Minimum base quality used in the pileup by ASEQ}

\item{mrq}{Minimum read quality used in the piluep by ASEQ}

\item{mdc}{Minimum read count acceptable for genotype inference by ASEQ}

\item{cores}{Number of parallel cores used for the analysis}

\item{verbose}{Print computation details}

\item{composite.model.call.rate}{SNPs call rate used to run Principal Component Analysis (PCA)}

\item{refinement.analysis}{Matrix specyfing a tree of ethnicities}
}
\value{
Logical value indicating the success of the analysis
}
\description{
This function performs ethnicity analysis of a set of samples from a list of BAM files or genotype data in VCF format ad reports the results.
}
\examples{

out.dir = file.path(tempdir(),"EthSEQ_Analysis/")

## Run the analysis
ethseq.Analysis(
  target.vcf = system.file("extdata", "Samples_SS2_10000SNPs.vcf",
	package="EthSEQ"),
  out.dir = out.dir,
  model.gds = system.file("extdata", "Reference_SS2_10000SNPs.gds",
	package="EthSEQ"),
  verbose=TRUE,
  composite.model.call.rate = 1)

## Load and display computed ethnicity annotations
ethseq.annotations = read.delim(file.path(out.dir,"Report.txt"),
	sep="\t",as.is=TRUE,header=TRUE)
head(ethseq.annotations)

## Delete analysis folder
unlink(out.dir,recursive=TRUE)

}
