% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_regional_results}
\alias{get_regional_results}
\title{Get Combined Regional Results}
\usage{
get_regional_results(
  regional_output,
  results_dir,
  date,
  samples = TRUE,
  forecast = FALSE
)
}
\arguments{
\item{regional_output}{A list of output as produced by \code{\link[=regional_epinow]{regional_epinow()}}
and stored in the \code{regional} list.}

\item{results_dir}{A character string indicating the folder containing the
\code{{EpiNow2}} results to extract.}

\item{date}{A Character string (in the format "yyyy-mm-dd") indicating the
date to extract data for. Defaults to "latest" which finds the latest
results available.}

\item{samples}{Logical, defaults to \code{TRUE}. Should samples be returned.}

\item{forecast}{Logical, defaults to \code{FALSE}. Should forecast results be
returned.}
}
\value{
A list of estimates, forecasts and estimated cases by date of report.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Summarises results across regions either from input or from disk. See the
examples for details.
}
\examples{
# get example multiregion estimates
regional_out <- readRDS(system.file(
  package = "EpiNow2", "extdata", "example_regional_epinow.rds"
))

# from output
results <- get_regional_results(regional_out$regional, samples = FALSE)
}
