% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{dist_skel}
\alias{dist_skel}
\title{Distribution Skeleton}
\usage{
dist_skel(n, dist = FALSE, cum = TRUE, model, params, max_value = 120)
}
\arguments{
\item{n}{Numeric vector, number of samples to take (or days for the probability density).}

\item{dist}{Logical, defaults to \code{FALSE}. Should the probability density be returned rather
than a number of samples.}

\item{cum}{Logical, defaults to \code{TRUE}. If \code{dist = TRUE} should the returned distribution be
cumulative.}

\item{model}{Character string, defining the model to be used. Supported options are exponential
("exp"), gamma ("gamma"), and log normal ("lognorm")}

\item{params}{A list of parameters values (by name) required for each model. For the exponential model
this is a rate parameter and for the gamma model this is alpha and beta.}

\item{max_value}{Numeric, the maximum value to allow. Defaults to 120. Samples outside
of this range are resampled.}
}
\value{
A vector of samples or a probability distribution.
}
\description{
This function acts as a skeleton for a truncated distribution defined by
model type, maximum value and model parameters. It is designed to be used with the
output from \code{get_dist}.
}
\examples{

## Exponential model

## Sample
dist_skel(10, model = "exp", params = list(rate = 1))

## Cumulative prob density
dist_skel(1:10, model = "exp", dist = TRUE, params = list(rate = 1))

## Probability density
dist_skel(1:10, model = "exp", dist = TRUE, 
          cum = FALSE, params = list(rate = 1))

## Gamma model

dist_skel(10, model = "gamma", params = list(alpha = 1, beta = 2))

## Cumulative prob density
dist_skel(0:10, model = "gamma", dist = TRUE,
          params = list(alpha = 1, beta = 2))

## Probability density
dist_skel(0:10, model = "gamma", dist = TRUE, 
          cum = FALSE, params = list(alpha = 2, beta = 2))

## Log normal model

dist_skel(10, model = "lognorm", params = list(mean = log(5), sd = log(2)))

## Cumulative prob density
dist_skel(0:10, model = "lognorm", dist = TRUE,
          params = list(mean = log(5), sd = log(2)))

## Probability density
dist_skel(0:10, model = "lognorm", dist = TRUE, cum = FALSE,
          params = list(mean = log(5), sd = log(2)))
        
}
